/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __SBP2_SCSI_COMMAND_H__
#define __SBP2_SCSI_COMMAND_H__


#include <glib.h>

#include <libsbp2/sbp2pointer.h>


typedef struct _SBP2ScsiCommandORB SBP2ScsiCommandORB;

struct _SBP2ScsiCommandORB
{
  SBP2Pointer next_ORB;
  SBP2Pointer data_desc;
#if G_BYTE_ORDER == G_BIG_ENDIAN
  guint       notify         : 1;
  guint       req_fmt        : 2;
  guint       reserved       : 1;
  guint       direction      : 1;
  guint       speed          : 3;
  guint       max_payload    : 4;
  guint       has_page_table : 1;
  guint       page_size      : 3;
  guint       data_size      : 16;
#else
  guint       data_size      : 16;
  guint       page_size      : 3;
  guint       has_page_table : 1;
  guint       max_payload    : 4;
  guint       speed          : 3;
  guint       direction      : 1;
  guint       reserved       : 1;
  guint       req_fmt        : 2;
  guint       notify         : 1;
#endif
  guint8      cdb[12];
};


#endif /* __SBP2_SCSI_COMMAND_H__ */
