/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __SBP2_STATUS_H__
#define __SBP2_STATUS_H__


#include <glib.h>

#include <libsbp2/sbp2pointer.h>


typedef enum
{
  SBP2_STATUS_ORIGIN_NON_NULL    = 0x0,
  SBP2_STATUS_ORIGIN_NULL        = 0x1,
  SBP2_STATUS_ORIGIN_UNSOLICITED = 0x2,
  SBP2_STATUS_ORIGIN_RESERVED    = 0x3
} SBP2StatusOrigin;

typedef enum
{
  SBP2_STATUS_RESP_REQUEST_COMPLETE  = 0x0,
  SBP2_STATUS_RESP_TRANSPORT_FAILURE = 0x1,
  SBP2_STATUS_RESP_ILLEGAL_REQUEST   = 0x2,
  SBP2_STATUS_RESP_VENDOR_DEPENDENT  = 0x3
} SBP2StatusResponse;

typedef enum
{
  SBP2_STATUS_REQUEST_NO_ADDITIONAL_INFO      = 0x0,
  SBP2_STATUS_REQUEST_REQ_TYPE_NOT_SUPPORTED  = 0x1,
  SBP2_STATUS_REQUEST_SPEED_NOT_SUPPORTED     = 0x2,
  SBP2_STATUS_REQUEST_PAGE_SIZE_NOT_SUPPORTED = 0x3,
  SBP2_STATUS_REQUEST_ACCESS_DENIED           = 0x4,
  SBP2_STATUS_REQUEST_LU_NOT_SUPPORTED        = 0x5,
  SBP2_STATUS_REQUEST_MAX_PAYLOAD_TOO_SMALL   = 0x6,
  SBP2_STATUS_REQUEST_RESOURCES_UNAVAILABLE   = 0x8,
  SBP2_STATUS_REQUEST_FUNCTION_REJECTED       = 0x9,
  SBP2_STATUS_REQUEST_LOGIN_ID_NOT_RECOGNIZED = 0xa,
  SBP2_STATUS_REQUEST_DUMMY_ORB_COMPLETED     = 0xb,
  SBP2_STATUS_REQUEST_REQUEST_ABORTED         = 0xc,
  SBP2_STATUS_REQUEST_UNSPECIFIED_ERROR       = 0xff
} SBP2StatusRequest;

/* TODO: transport failure error codes */


typedef struct _SBP2Status SBP2Status;

struct _SBP2Status
{
#if G_BYTE_ORDER == G_BIG_ENDIAN
  guint   src        : 2;
  guint   resp       : 2;
  guint   dead       : 1;
  guint   len        : 3;
  guint   sbp_status : 8;
  guint   ORB_hi     : 16;
#else
  guint   ORB_hi     : 16;
  guint   sbp_status : 8;
  guint   len        : 3;
  guint   dead       : 1;
  guint   resp       : 2;
  guint   src        : 2;
#endif
  guint32 ORB_lo;
  guint8  sense[24];
};


static inline void
sbp2_status_fill_pointer (SBP2Status  *s,
                          SBP2Pointer *p)
{
  s->ORB_hi = p->addr_hi;
  s->ORB_lo = p->addr_lo;
}


#endif /* __SBP2_STATUS_H__ */
