/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __WIRE_MESSAGES_H__
#define __WIRE_MESSAGES_H__


#include <glib.h>

#include <libraw1394/raw1394.h>

#include <libsbp2/sbp2login.h>

#include "app.h"


typedef enum
{
  WIRE_LOGIN,
  WIRE_RECONNECT,
  WIRE_LOGOUT,

  WIRE_WORKER_ACTIVE,
  WIRE_WORKER_DIED
} WireMessageType;


typedef struct _WireHeader WireHeader;

typedef struct _WireLogin WireLogin;
typedef struct _WireReconnect WireReconnect;

typedef struct _WireLoginID WireLogout;
typedef struct _WireLoginID WireWorkerActive;
typedef struct _WireLoginID WireWorkerDied;

typedef struct _WireMsgFuncs WireMsgFuncs;

struct _WireHeader
{
  WireMessageType type;
};

struct _WireLogin
{
  WireHeader   header;

  guint        login_ID;
  gint         port;

  nodeid_t     node;
  SBP2Pointer  pointer;
  SBP2LoginORB orb;
};

struct _WireReconnect
{
  WireHeader header;

  guint      login_ID;
  nodeid_t   node;
};

struct _WireLoginID
{
  WireHeader header;

  guint      login_ID;
};

struct _WireMsgFuncs
{
  gboolean (*login)         (EndpointApp      *app,
			     WireLogin        *message);
  gboolean (*reconnect)     (EndpointApp      *app,
			     WireReconnect    *message);
  gboolean (*logout)        (EndpointApp      *app,
			     WireLogout       *message);

  gboolean (*worker_active) (EndpointApp      *app,
			     WireWorkerActive *message);
  gboolean (*worker_died)   (EndpointApp      *app,
			     WireWorkerDied   *message);
};


gboolean wire_init                  (void);

gboolean wire_message_send          (GIOChannel   *channel,
				     gpointer      message,
				     EndpointApp  *app);
gboolean wire_message_process       (GIOChannel   *channel,
				     GIOCondition  condition,
				     EndpointApp  *app);

gpointer wire_message_copy          (gpointer      message);

gpointer wire_message_login         (guint         login_ID,
				     gint          port,
				     nodeid_t      node,
				     SBP2Pointer  *pointer,
				     SBP2LoginORB *orb);
gpointer wire_message_reconnect     (guint         login_ID,
				     nodeid_t      node);
gpointer wire_message_logout        (guint         login_ID);

gpointer wire_message_worker_active (guint         login_ID);
gpointer wire_message_worker_died   (guint         login_ID);


#endif /* __WIRE_MESSAGES_H__ */
