// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#include "generator/integration_tests/golden/v1/internal/request_id_option_defaults.h"
#include "generator/integration_tests/golden/v1/request_id_connection.h"
#include "generator/integration_tests/golden/v1/request_id_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options RequestIdServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_REQUEST_ID_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_REQUEST_ID_SERVICE_AUTHORITY",
      "test.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<golden_v1::RequestIdServiceRetryPolicyOption>()) {
    options.set<golden_v1::RequestIdServiceRetryPolicyOption>(
        golden_v1::RequestIdServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30)).clone());
  }
  if (!options.has<golden_v1::RequestIdServiceBackoffPolicyOption>()) {
    options.set<golden_v1::RequestIdServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling).clone());
  }
  if (!options.has<golden_v1::RequestIdServicePollingPolicyOption>()) {
    options.set<golden_v1::RequestIdServicePollingPolicyOption>(
        GenericPollingPolicy<
            golden_v1::RequestIdServiceRetryPolicyOption::Type,
            golden_v1::RequestIdServiceBackoffPolicyOption::Type>(
            options.get<golden_v1::RequestIdServiceRetryPolicyOption>()->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling).clone()).clone());
  }
  if (!options.has<golden_v1::RequestIdServiceConnectionIdempotencyPolicyOption>()) {
    options.set<golden_v1::RequestIdServiceConnectionIdempotencyPolicyOption>(
        golden_v1::MakeDefaultRequestIdServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
