// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_service.proto

#include "google/cloud/aiplatform/v1/featurestore_connection.h"
#include "google/cloud/aiplatform/v1/featurestore_options.h"
#include "google/cloud/aiplatform/v1/internal/featurestore_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/featurestore_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/featurestore_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/featurestore_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FeaturestoreServiceConnection::~FeaturestoreServiceConnection() = default;

future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
FeaturestoreServiceConnection::CreateFeaturestore(
    google::cloud::aiplatform::v1::CreateFeaturestoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Featurestore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::CreateFeaturestore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateFeaturestoreRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
FeaturestoreServiceConnection::CreateFeaturestore(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Featurestore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::Featurestore>
FeaturestoreServiceConnection::GetFeaturestore(
    google::cloud::aiplatform::v1::GetFeaturestoreRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::Featurestore>
FeaturestoreServiceConnection::ListFeaturestores(
    google::cloud::aiplatform::v1::
        ListFeaturestoresRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Featurestore>>();
}

future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
FeaturestoreServiceConnection::UpdateFeaturestore(
    google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Featurestore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::UpdateFeaturestore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
FeaturestoreServiceConnection::UpdateFeaturestore(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Featurestore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeaturestoreServiceConnection::DeleteFeaturestore(
    google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::DeleteFeaturestore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeaturestoreServiceConnection::DeleteFeaturestore(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::EntityType>>
FeaturestoreServiceConnection::CreateEntityType(
    google::cloud::aiplatform::v1::CreateEntityTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::EntityType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::CreateEntityType(
    NoAwaitTag, google::cloud::aiplatform::v1::CreateEntityTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::EntityType>>
FeaturestoreServiceConnection::CreateEntityType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::EntityType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::EntityType>
FeaturestoreServiceConnection::GetEntityType(
    google::cloud::aiplatform::v1::GetEntityTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::EntityType>
FeaturestoreServiceConnection::ListEntityTypes(
    google::cloud::aiplatform::v1::
        ListEntityTypesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::EntityType>>();
}

StatusOr<google::cloud::aiplatform::v1::EntityType>
FeaturestoreServiceConnection::UpdateEntityType(
    google::cloud::aiplatform::v1::UpdateEntityTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeaturestoreServiceConnection::DeleteEntityType(
    google::cloud::aiplatform::v1::DeleteEntityTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::DeleteEntityType(
    NoAwaitTag, google::cloud::aiplatform::v1::DeleteEntityTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeaturestoreServiceConnection::DeleteEntityType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeaturestoreServiceConnection::CreateFeature(
    google::cloud::aiplatform::v1::CreateFeatureRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Feature>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::CreateFeature(
    NoAwaitTag, google::cloud::aiplatform::v1::CreateFeatureRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeaturestoreServiceConnection::CreateFeature(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Feature>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::BatchCreateFeaturesResponse>>
FeaturestoreServiceConnection::BatchCreateFeatures(
    google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::BatchCreateFeaturesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::BatchCreateFeatures(
    NoAwaitTag,
    google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::BatchCreateFeaturesResponse>>
FeaturestoreServiceConnection::BatchCreateFeatures(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::BatchCreateFeaturesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::Feature>
FeaturestoreServiceConnection::GetFeature(
    google::cloud::aiplatform::v1::GetFeatureRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::Feature>
FeaturestoreServiceConnection::ListFeatures(
    google::cloud::aiplatform::v1::
        ListFeaturesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Feature>>();
}

StatusOr<google::cloud::aiplatform::v1::Feature>
FeaturestoreServiceConnection::UpdateFeature(
    google::cloud::aiplatform::v1::UpdateFeatureRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeaturestoreServiceConnection::DeleteFeature(
    google::cloud::aiplatform::v1::DeleteFeatureRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::DeleteFeature(
    NoAwaitTag, google::cloud::aiplatform::v1::DeleteFeatureRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeaturestoreServiceConnection::DeleteFeature(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::ImportFeatureValuesResponse>>
FeaturestoreServiceConnection::ImportFeatureValues(
    google::cloud::aiplatform::v1::ImportFeatureValuesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::ImportFeatureValuesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::ImportFeatureValues(
    NoAwaitTag,
    google::cloud::aiplatform::v1::ImportFeatureValuesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::ImportFeatureValuesResponse>>
FeaturestoreServiceConnection::ImportFeatureValues(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::ImportFeatureValuesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::BatchReadFeatureValuesResponse>>
FeaturestoreServiceConnection::BatchReadFeatureValues(
    google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::BatchReadFeatureValuesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::BatchReadFeatureValues(
    NoAwaitTag,
    google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::BatchReadFeatureValuesResponse>>
FeaturestoreServiceConnection::BatchReadFeatureValues(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::BatchReadFeatureValuesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::ExportFeatureValuesResponse>>
FeaturestoreServiceConnection::ExportFeatureValues(
    google::cloud::aiplatform::v1::ExportFeatureValuesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::ExportFeatureValuesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::ExportFeatureValues(
    NoAwaitTag,
    google::cloud::aiplatform::v1::ExportFeatureValuesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::ExportFeatureValuesResponse>>
FeaturestoreServiceConnection::ExportFeatureValues(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::ExportFeatureValuesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteFeatureValuesResponse>>
FeaturestoreServiceConnection::DeleteFeatureValues(
    google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteFeatureValuesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeaturestoreServiceConnection::DeleteFeatureValues(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteFeatureValuesResponse>>
FeaturestoreServiceConnection::DeleteFeatureValues(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteFeatureValuesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::aiplatform::v1::Feature>
FeaturestoreServiceConnection::SearchFeatures(
    google::cloud::aiplatform::v1::
        SearchFeaturesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Feature>>();
}

std::shared_ptr<FeaturestoreServiceConnection>
MakeFeaturestoreServiceConnection(std::string const& location,
                                  Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 FeaturestoreServicePolicyOptionList>(options,
                                                                      __func__);
  options = aiplatform_v1_internal::FeaturestoreServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = aiplatform_v1_internal::CreateDefaultFeaturestoreServiceStub(
      std::move(auth), options);
  return aiplatform_v1_internal::MakeFeaturestoreServiceTracingConnection(
      std::make_shared<
          aiplatform_v1_internal::FeaturestoreServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
