// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#include "google/cloud/apphub/v1/internal/app_hub_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/apphub/v1/apphub_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace apphub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AppHubMetadata::AppHubMetadata(
    std::shared_ptr<AppHubStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
AppHubMetadata::LookupServiceProjectAttachment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->LookupServiceProjectAttachment(context, options, request);
}

StatusOr<google::cloud::apphub::v1::ListServiceProjectAttachmentsResponse>
AppHubMetadata::ListServiceProjectAttachments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListServiceProjectAttachments(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncCreateServiceProjectAttachment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateServiceProjectAttachment(
      cq, std::move(context), std::move(options), request);
}

StatusOr<google::longrunning::Operation>
AppHubMetadata::CreateServiceProjectAttachment(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateServiceProjectAttachment(context, options, request);
}

StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubMetadata::GetServiceProjectAttachment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetServiceProjectAttachment(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncDeleteServiceProjectAttachment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteServiceProjectAttachment(
      cq, std::move(context), std::move(options), request);
}

StatusOr<google::longrunning::Operation>
AppHubMetadata::DeleteServiceProjectAttachment(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteServiceProjectAttachment(context, options, request);
}

StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
AppHubMetadata::DetachServiceProjectAttachment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DetachServiceProjectAttachment(context, options, request);
}

StatusOr<google::cloud::apphub::v1::ListDiscoveredServicesResponse>
AppHubMetadata::ListDiscoveredServices(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListDiscoveredServicesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDiscoveredServices(context, options, request);
}

StatusOr<google::cloud::apphub::v1::DiscoveredService>
AppHubMetadata::GetDiscoveredService(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetDiscoveredServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDiscoveredService(context, options, request);
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
AppHubMetadata::LookupDiscoveredService(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::LookupDiscoveredServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->LookupDiscoveredService(context, options, request);
}

StatusOr<google::cloud::apphub::v1::ListServicesResponse>
AppHubMetadata::ListServices(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListServicesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListServices(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncCreateService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::CreateServiceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateService(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::CreateService(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::CreateServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateService(context, options, request);
}

StatusOr<google::cloud::apphub::v1::Service> AppHubMetadata::GetService(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetService(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncUpdateService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::UpdateServiceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("service.name=",
                           internal::UrlEncode(request.service().name())));
  return child_->AsyncUpdateService(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::UpdateService(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::UpdateServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("service.name=",
                           internal::UrlEncode(request.service().name())));
  return child_->UpdateService(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncDeleteService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::DeleteServiceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteService(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::DeleteService(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::DeleteServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteService(context, options, request);
}

StatusOr<google::cloud::apphub::v1::ListDiscoveredWorkloadsResponse>
AppHubMetadata::ListDiscoveredWorkloads(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDiscoveredWorkloads(context, options, request);
}

StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubMetadata::GetDiscoveredWorkload(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDiscoveredWorkload(context, options, request);
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
AppHubMetadata::LookupDiscoveredWorkload(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->LookupDiscoveredWorkload(context, options, request);
}

StatusOr<google::cloud::apphub::v1::ListWorkloadsResponse>
AppHubMetadata::ListWorkloads(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListWorkloadsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListWorkloads(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncCreateWorkload(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateWorkload(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::CreateWorkload(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateWorkload(context, options, request);
}

StatusOr<google::cloud::apphub::v1::Workload> AppHubMetadata::GetWorkload(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetWorkloadRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetWorkload(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncUpdateWorkload(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("workload.name=",
                           internal::UrlEncode(request.workload().name())));
  return child_->AsyncUpdateWorkload(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::UpdateWorkload(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("workload.name=",
                           internal::UrlEncode(request.workload().name())));
  return child_->UpdateWorkload(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncDeleteWorkload(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteWorkload(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::DeleteWorkload(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteWorkload(context, options, request);
}

StatusOr<google::cloud::apphub::v1::ListApplicationsResponse>
AppHubMetadata::ListApplications(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListApplicationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListApplications(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncCreateApplication(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::CreateApplicationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateApplication(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::CreateApplication(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::CreateApplicationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateApplication(context, options, request);
}

StatusOr<google::cloud::apphub::v1::Application> AppHubMetadata::GetApplication(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetApplicationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetApplication(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncUpdateApplication(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("application.name=",
                           internal::UrlEncode(request.application().name())));
  return child_->AsyncUpdateApplication(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::UpdateApplication(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("application.name=",
                           internal::UrlEncode(request.application().name())));
  return child_->UpdateApplication(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncDeleteApplication(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteApplication(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation> AppHubMetadata::DeleteApplication(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteApplication(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppHubMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> AppHubMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void AppHubMetadata::SetMetadata(grpc::ClientContext& context,
                                 Options const& options,
                                 std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void AppHubMetadata::SetMetadata(grpc::ClientContext& context,
                                 Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1_internal
}  // namespace cloud
}  // namespace google
