// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/beyondcorp/appconnections/v1/app_connections_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPCONNECTIONS_V1_INTERNAL_APP_CONNECTIONS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPCONNECTIONS_V1_INTERNAL_APP_CONNECTIONS_CONNECTION_IMPL_H

#include "google/cloud/beyondcorp/appconnections/v1/app_connections_connection.h"
#include "google/cloud/beyondcorp/appconnections/v1/app_connections_connection_idempotency_policy.h"
#include "google/cloud/beyondcorp/appconnections/v1/app_connections_options.h"
#include "google/cloud/beyondcorp/appconnections/v1/internal/app_connections_retry_traits.h"
#include "google/cloud/beyondcorp/appconnections/v1/internal/app_connections_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace beyondcorp_appconnections_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AppConnectionsServiceConnectionImpl
    : public beyondcorp_appconnections_v1::AppConnectionsServiceConnection {
 public:
  ~AppConnectionsServiceConnectionImpl() override = default;

  AppConnectionsServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          beyondcorp_appconnections_v1_internal::AppConnectionsServiceStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::beyondcorp::appconnections::v1::AppConnection>
  ListAppConnections(
      google::cloud::beyondcorp::appconnections::v1::ListAppConnectionsRequest
          request) override;

  StatusOr<google::cloud::beyondcorp::appconnections::v1::AppConnection>
  GetAppConnection(google::cloud::beyondcorp::appconnections::v1::
                       GetAppConnectionRequest const& request) override;

  future<StatusOr<google::cloud::beyondcorp::appconnections::v1::AppConnection>>
  CreateAppConnection(google::cloud::beyondcorp::appconnections::v1::
                          CreateAppConnectionRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateAppConnection(
      NoAwaitTag, google::cloud::beyondcorp::appconnections::v1::
                      CreateAppConnectionRequest const& request) override;

  future<StatusOr<google::cloud::beyondcorp::appconnections::v1::AppConnection>>
  CreateAppConnection(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::beyondcorp::appconnections::v1::AppConnection>>
  UpdateAppConnection(google::cloud::beyondcorp::appconnections::v1::
                          UpdateAppConnectionRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateAppConnection(
      NoAwaitTag, google::cloud::beyondcorp::appconnections::v1::
                      UpdateAppConnectionRequest const& request) override;

  future<StatusOr<google::cloud::beyondcorp::appconnections::v1::AppConnection>>
  UpdateAppConnection(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::beyondcorp::appconnections::v1::
                      AppConnectionOperationMetadata>>
  DeleteAppConnection(google::cloud::beyondcorp::appconnections::v1::
                          DeleteAppConnectionRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteAppConnection(
      NoAwaitTag, google::cloud::beyondcorp::appconnections::v1::
                      DeleteAppConnectionRequest const& request) override;

  future<StatusOr<google::cloud::beyondcorp::appconnections::v1::
                      AppConnectionOperationMetadata>>
  DeleteAppConnection(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::beyondcorp::appconnections::v1::
                  ResolveAppConnectionsResponse::AppConnectionDetails>
  ResolveAppConnections(google::cloud::beyondcorp::appconnections::v1::
                            ResolveAppConnectionsRequest request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      beyondcorp_appconnections_v1_internal::AppConnectionsServiceStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appconnections_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPCONNECTIONS_V1_INTERNAL_APP_CONNECTIONS_CONNECTION_IMPL_H
