// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/biglake/v1/metastore.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_INTERNAL_METASTORE_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_INTERNAL_METASTORE_CONNECTION_IMPL_H

#include "google/cloud/bigquery/biglake/v1/internal/metastore_retry_traits.h"
#include "google/cloud/bigquery/biglake/v1/internal/metastore_stub.h"
#include "google/cloud/bigquery/biglake/v1/metastore_connection.h"
#include "google/cloud/bigquery/biglake/v1/metastore_connection_idempotency_policy.h"
#include "google/cloud/bigquery/biglake/v1/metastore_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_biglake_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MetastoreServiceConnectionImpl
    : public bigquery_biglake_v1::MetastoreServiceConnection {
 public:
  ~MetastoreServiceConnectionImpl() override = default;

  MetastoreServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<bigquery_biglake_v1_internal::MetastoreServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> CreateCatalog(
      google::cloud::bigquery::biglake::v1::CreateCatalogRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> DeleteCatalog(
      google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> GetCatalog(
      google::cloud::bigquery::biglake::v1::GetCatalogRequest const& request)
      override;

  StreamRange<google::cloud::bigquery::biglake::v1::Catalog> ListCatalogs(
      google::cloud::bigquery::biglake::v1::ListCatalogsRequest request)
      override;

  StatusOr<google::cloud::bigquery::biglake::v1::Database> CreateDatabase(
      google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const&
          request) override;

  StatusOr<google::cloud::bigquery::biglake::v1::Database> DeleteDatabase(
      google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const&
          request) override;

  StatusOr<google::cloud::bigquery::biglake::v1::Database> UpdateDatabase(
      google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const&
          request) override;

  StatusOr<google::cloud::bigquery::biglake::v1::Database> GetDatabase(
      google::cloud::bigquery::biglake::v1::GetDatabaseRequest const& request)
      override;

  StreamRange<google::cloud::bigquery::biglake::v1::Database> ListDatabases(
      google::cloud::bigquery::biglake::v1::ListDatabasesRequest request)
      override;

  StatusOr<google::cloud::bigquery::biglake::v1::Table> CreateTable(
      google::cloud::bigquery::biglake::v1::CreateTableRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::biglake::v1::Table> DeleteTable(
      google::cloud::bigquery::biglake::v1::DeleteTableRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::biglake::v1::Table> UpdateTable(
      google::cloud::bigquery::biglake::v1::UpdateTableRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::biglake::v1::Table> RenameTable(
      google::cloud::bigquery::biglake::v1::RenameTableRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::biglake::v1::Table> GetTable(
      google::cloud::bigquery::biglake::v1::GetTableRequest const& request)
      override;

  StreamRange<google::cloud::bigquery::biglake::v1::Table> ListTables(
      google::cloud::bigquery::biglake::v1::ListTablesRequest request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<bigquery_biglake_v1_internal::MetastoreServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_biglake_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_INTERNAL_METASTORE_CONNECTION_IMPL_H
