// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/routine.proto

#include "google/cloud/bigquerycontrol/v2/routine_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RoutineServiceClient::RoutineServiceClient(
    std::shared_ptr<RoutineServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RoutineServiceClient::~RoutineServiceClient() = default;

StatusOr<google::cloud::bigquery::v2::Routine> RoutineServiceClient::GetRoutine(
    google::cloud::bigquery::v2::GetRoutineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRoutine(request);
}

StatusOr<google::cloud::bigquery::v2::Routine>
RoutineServiceClient::InsertRoutine(
    google::cloud::bigquery::v2::InsertRoutineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertRoutine(request);
}

StatusOr<google::cloud::bigquery::v2::Routine>
RoutineServiceClient::UpdateRoutine(
    google::cloud::bigquery::v2::UpdateRoutineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRoutine(request);
}

StatusOr<google::cloud::bigquery::v2::Routine>
RoutineServiceClient::PatchRoutine(
    google::cloud::bigquery::v2::PatchRoutineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchRoutine(request);
}

Status RoutineServiceClient::DeleteRoutine(
    google::cloud::bigquery::v2::DeleteRoutineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRoutine(request);
}

StatusOr<google::cloud::bigquery::v2::ListRoutinesResponse>
RoutineServiceClient::ListRoutines(
    google::cloud::bigquery::v2::ListRoutinesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRoutines(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
