// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/reservations/v1/reservations.proto

#include "google/cloud/compute/reservations/v1/reservations_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_reservations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ReservationsConnectionIdempotencyPolicy::
    ~ReservationsConnectionIdempotencyPolicy() = default;

std::unique_ptr<ReservationsConnectionIdempotencyPolicy>
ReservationsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ReservationsConnectionIdempotencyPolicy>(*this);
}

Idempotency ReservationsConnectionIdempotencyPolicy::AggregatedListReservations(
    google::cloud::cpp::compute::reservations::v1::
        AggregatedListReservationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::DeleteReservation(
    google::cloud::cpp::compute::reservations::v1::
        DeleteReservationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::GetReservation(
    google::cloud::cpp::compute::reservations::v1::
        GetReservationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::GetIamPolicy(
    google::cloud::cpp::compute::reservations::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::InsertReservation(
    google::cloud::cpp::compute::reservations::v1::
        InsertReservationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::ListReservations(
    google::cloud::cpp::compute::reservations::v1::
        ListReservationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::Resize(
    google::cloud::cpp::compute::reservations::v1::ResizeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::SetIamPolicy(
    google::cloud::cpp::compute::reservations::v1::SetIamPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::TestIamPermissions(
    google::cloud::cpp::compute::reservations::v1::
        TestIamPermissionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ReservationsConnectionIdempotencyPolicy::UpdateReservation(
    google::cloud::cpp::compute::reservations::v1::
        UpdateReservationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ReservationsConnectionIdempotencyPolicy>
MakeDefaultReservationsConnectionIdempotencyPolicy() {
  return std::make_unique<ReservationsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_reservations_v1
}  // namespace cloud
}  // namespace google
