// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_connection_impl.h"
#include "google/cloud/contentwarehouse/v1/internal/document_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<contentwarehouse_v1::DocumentServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<contentwarehouse_v1::DocumentServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<contentwarehouse_v1::DocumentServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<contentwarehouse_v1::DocumentServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<contentwarehouse_v1::
               DocumentServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

DocumentServiceConnectionImpl::DocumentServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<contentwarehouse_v1_internal::DocumentServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      DocumentServiceConnection::options())) {}

StatusOr<google::cloud::contentwarehouse::v1::CreateDocumentResponse>
DocumentServiceConnectionImpl::CreateDocument(
    google::cloud::contentwarehouse::v1::CreateDocumentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDocument(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contentwarehouse::v1::CreateDocumentRequest const&
                 request) {
        return stub_->CreateDocument(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DocumentServiceConnectionImpl::GetDocument(
    google::cloud::contentwarehouse::v1::GetDocumentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDocument(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contentwarehouse::v1::GetDocumentRequest const&
                 request) {
        return stub_->GetDocument(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contentwarehouse::v1::UpdateDocumentResponse>
DocumentServiceConnectionImpl::UpdateDocument(
    google::cloud::contentwarehouse::v1::UpdateDocumentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDocument(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contentwarehouse::v1::UpdateDocumentRequest const&
                 request) {
        return stub_->UpdateDocument(context, options, request);
      },
      *current, request, __func__);
}

Status DocumentServiceConnectionImpl::DeleteDocument(
    google::cloud::contentwarehouse::v1::DeleteDocumentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDocument(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contentwarehouse::v1::DeleteDocumentRequest const&
                 request) {
        return stub_->DeleteDocument(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::contentwarehouse::v1::SearchDocumentsResponse::
                MatchingDocument>
DocumentServiceConnectionImpl::SearchDocuments(
    google::cloud::contentwarehouse::v1::SearchDocumentsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->SearchDocuments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::contentwarehouse::v1::SearchDocumentsResponse::
                      MatchingDocument>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<contentwarehouse_v1::DocumentServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::contentwarehouse::v1::SearchDocumentsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::contentwarehouse::v1::
                       SearchDocumentsRequest const& request) {
              return stub->SearchDocuments(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::contentwarehouse::v1::SearchDocumentsResponse r) {
        std::vector<google::cloud::contentwarehouse::v1::
                        SearchDocumentsResponse::MatchingDocument>
            result(r.matching_documents().size());
        auto& messages = *r.mutable_matching_documents();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DocumentServiceConnectionImpl::LockDocument(
    google::cloud::contentwarehouse::v1::LockDocumentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->LockDocument(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contentwarehouse::v1::LockDocumentRequest const&
                 request) {
        return stub_->LockDocument(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contentwarehouse::v1::FetchAclResponse>
DocumentServiceConnectionImpl::FetchAcl(
    google::cloud::contentwarehouse::v1::FetchAclRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->FetchAcl(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::contentwarehouse::v1::FetchAclRequest const& request) {
        return stub_->FetchAcl(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contentwarehouse::v1::SetAclResponse>
DocumentServiceConnectionImpl::SetAcl(
    google::cloud::contentwarehouse::v1::SetAclRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetAcl(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::contentwarehouse::v1::SetAclRequest const& request) {
        return stub_->SetAcl(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
