// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datafusion/v1/datafusion.proto

#include "google/cloud/datafusion/v1/data_fusion_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace datafusion_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DataFusionConnectionIdempotencyPolicy::
    ~DataFusionConnectionIdempotencyPolicy() = default;

std::unique_ptr<DataFusionConnectionIdempotencyPolicy>
DataFusionConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DataFusionConnectionIdempotencyPolicy>(*this);
}

Idempotency DataFusionConnectionIdempotencyPolicy::ListAvailableVersions(
    google::cloud::datafusion::v1::ListAvailableVersionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataFusionConnectionIdempotencyPolicy::ListInstances(
    google::cloud::datafusion::v1::ListInstancesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataFusionConnectionIdempotencyPolicy::GetInstance(
    google::cloud::datafusion::v1::GetInstanceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataFusionConnectionIdempotencyPolicy::CreateInstance(
    google::cloud::datafusion::v1::CreateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataFusionConnectionIdempotencyPolicy::DeleteInstance(
    google::cloud::datafusion::v1::DeleteInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataFusionConnectionIdempotencyPolicy::UpdateInstance(
    google::cloud::datafusion::v1::UpdateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataFusionConnectionIdempotencyPolicy::RestartInstance(
    google::cloud::datafusion::v1::RestartInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<DataFusionConnectionIdempotencyPolicy>
MakeDefaultDataFusionConnectionIdempotencyPolicy() {
  return std::make_unique<DataFusionConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datafusion_v1
}  // namespace cloud
}  // namespace google
