// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/developerconnect/v1/developer_connect.proto

#include "google/cloud/developerconnect/v1/internal/developer_connect_connection_impl.h"
#include "google/cloud/developerconnect/v1/internal/developer_connect_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace developerconnect_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<developerconnect_v1::DeveloperConnectRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<developerconnect_v1::DeveloperConnectRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<developerconnect_v1::DeveloperConnectBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    developerconnect_v1::DeveloperConnectConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<developerconnect_v1::
               DeveloperConnectConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<developerconnect_v1::DeveloperConnectPollingPolicyOption>()
      ->clone();
}

}  // namespace

DeveloperConnectConnectionImpl::DeveloperConnectConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<developerconnect_v1_internal::DeveloperConnectStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      DeveloperConnectConnection::options())) {}

StreamRange<google::cloud::developerconnect::v1::Connection>
DeveloperConnectConnectionImpl::ListConnections(
    google::cloud::developerconnect::v1::ListConnectionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListConnections(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::developerconnect::v1::Connection>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<developerconnect_v1::DeveloperConnectRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::developerconnect::v1::ListConnectionsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::developerconnect::v1::
                       ListConnectionsRequest const& request) {
              return stub->ListConnections(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::developerconnect::v1::ListConnectionsResponse r) {
        std::vector<google::cloud::developerconnect::v1::Connection> result(
            r.connections().size());
        auto& messages = *r.mutable_connections();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::developerconnect::v1::Connection>
DeveloperConnectConnectionImpl::GetConnection(
    google::cloud::developerconnect::v1::GetConnectionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::GetConnectionRequest const&
                 request) {
        return stub_->GetConnection(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::Connection>>
DeveloperConnectConnectionImpl::CreateConnection(
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateConnection(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::developerconnect::v1::Connection>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::developerconnect::v1::CreateConnectionRequest const&
              request) {
        return stub->AsyncCreateConnection(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::developerconnect::v1::Connection>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectConnectionImpl::CreateConnection(
    NoAwaitTag,
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::CreateConnectionRequest const&
                 request) {
        return stub_->CreateConnection(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::Connection>>
DeveloperConnectConnectionImpl::CreateConnection(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::developerconnect::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::developerconnect::v1::Connection>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateConnection",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::developerconnect::v1::Connection>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::developerconnect::v1::Connection>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::Connection>>
DeveloperConnectConnectionImpl::UpdateConnection(
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateConnection(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::developerconnect::v1::Connection>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::developerconnect::v1::UpdateConnectionRequest const&
              request) {
        return stub->AsyncUpdateConnection(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::developerconnect::v1::Connection>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectConnectionImpl::UpdateConnection(
    NoAwaitTag,
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::UpdateConnectionRequest const&
                 request) {
        return stub_->UpdateConnection(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::Connection>>
DeveloperConnectConnectionImpl::UpdateConnection(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::developerconnect::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::developerconnect::v1::Connection>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateConnection",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::developerconnect::v1::Connection>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::developerconnect::v1::Connection>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
DeveloperConnectConnectionImpl::DeleteConnection(
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteConnection(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::developerconnect::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::developerconnect::v1::DeleteConnectionRequest const&
              request) {
        return stub->AsyncDeleteConnection(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::developerconnect::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectConnectionImpl::DeleteConnection(
    NoAwaitTag,
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::DeleteConnectionRequest const&
                 request) {
        return stub_->DeleteConnection(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
DeveloperConnectConnectionImpl::DeleteConnection(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::developerconnect::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteConnection",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::developerconnect::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::developerconnect::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>>
DeveloperConnectConnectionImpl::CreateGitRepositoryLink(
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateGitRepositoryLink(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::developerconnect::v1::GitRepositoryLink>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::developerconnect::v1::
                         CreateGitRepositoryLinkRequest const& request) {
        return stub->AsyncCreateGitRepositoryLink(cq, std::move(context),
                                                  std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::developerconnect::v1::GitRepositoryLink>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectConnectionImpl::CreateGitRepositoryLink(
    NoAwaitTag,
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateGitRepositoryLink(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 CreateGitRepositoryLinkRequest const& request) {
        return stub_->CreateGitRepositoryLink(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>>
DeveloperConnectConnectionImpl::CreateGitRepositoryLink(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::developerconnect::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateGitRepositoryLink",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::developerconnect::v1::GitRepositoryLink>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::developerconnect::v1::GitRepositoryLink>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
DeveloperConnectConnectionImpl::DeleteGitRepositoryLink(
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteGitRepositoryLink(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::developerconnect::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::developerconnect::v1::
                         DeleteGitRepositoryLinkRequest const& request) {
        return stub->AsyncDeleteGitRepositoryLink(cq, std::move(context),
                                                  std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::developerconnect::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectConnectionImpl::DeleteGitRepositoryLink(
    NoAwaitTag,
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteGitRepositoryLink(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 DeleteGitRepositoryLinkRequest const& request) {
        return stub_->DeleteGitRepositoryLink(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
DeveloperConnectConnectionImpl::DeleteGitRepositoryLink(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::developerconnect::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteGitRepositoryLink",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::developerconnect::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::developerconnect::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::developerconnect::v1::GitRepositoryLink>
DeveloperConnectConnectionImpl::ListGitRepositoryLinks(
    google::cloud::developerconnect::v1::ListGitRepositoryLinksRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListGitRepositoryLinks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::developerconnect::v1::GitRepositoryLink>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<developerconnect_v1::DeveloperConnectRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options, google::cloud::developerconnect::v1::
                                      ListGitRepositoryLinksRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::developerconnect::v1::
                       ListGitRepositoryLinksRequest const& request) {
              return stub->ListGitRepositoryLinks(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::developerconnect::v1::ListGitRepositoryLinksResponse
             r) {
        std::vector<google::cloud::developerconnect::v1::GitRepositoryLink>
            result(r.git_repository_links().size());
        auto& messages = *r.mutable_git_repository_links();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>
DeveloperConnectConnectionImpl::GetGitRepositoryLink(
    google::cloud::developerconnect::v1::GetGitRepositoryLinkRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGitRepositoryLink(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 GetGitRepositoryLinkRequest const& request) {
        return stub_->GetGitRepositoryLink(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::developerconnect::v1::FetchReadWriteTokenResponse>
DeveloperConnectConnectionImpl::FetchReadWriteToken(
    google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->FetchReadWriteToken(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&
              request) {
        return stub_->FetchReadWriteToken(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::developerconnect::v1::FetchReadTokenResponse>
DeveloperConnectConnectionImpl::FetchReadToken(
    google::cloud::developerconnect::v1::FetchReadTokenRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->FetchReadToken(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::FetchReadTokenRequest const&
                 request) {
        return stub_->FetchReadToken(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::developerconnect::v1::LinkableGitRepository>
DeveloperConnectConnectionImpl::FetchLinkableGitRepositories(
    google::cloud::developerconnect::v1::FetchLinkableGitRepositoriesRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->FetchLinkableGitRepositories(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::developerconnect::v1::LinkableGitRepository>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<developerconnect_v1::DeveloperConnectRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::developerconnect::v1::
              FetchLinkableGitRepositoriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::developerconnect::v1::
                       FetchLinkableGitRepositoriesRequest const& request) {
              return stub->FetchLinkableGitRepositories(context, options,
                                                        request);
            },
            options, r, function_name);
      },
      [](google::cloud::developerconnect::v1::
             FetchLinkableGitRepositoriesResponse r) {
        std::vector<google::cloud::developerconnect::v1::LinkableGitRepository>
            result(r.linkable_git_repositories().size());
        auto& messages = *r.mutable_linkable_git_repositories();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::developerconnect::v1::FetchGitHubInstallationsResponse>
DeveloperConnectConnectionImpl::FetchGitHubInstallations(
    google::cloud::developerconnect::v1::FetchGitHubInstallationsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->FetchGitHubInstallations(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 FetchGitHubInstallationsRequest const& request) {
        return stub_->FetchGitHubInstallations(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<std::string> DeveloperConnectConnectionImpl::FetchGitRefs(
    google::cloud::developerconnect::v1::FetchGitRefsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->FetchGitRefs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<std::string>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<developerconnect_v1::DeveloperConnectRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::developerconnect::v1::FetchGitRefsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::developerconnect::v1::FetchGitRefsRequest const&
                    request) {
              return stub->FetchGitRefs(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::developerconnect::v1::FetchGitRefsResponse r) {
        std::vector<std::string> result(r.ref_names().size());
        auto& messages = *r.mutable_ref_names();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace developerconnect_v1_internal
}  // namespace cloud
}  // namespace google
