// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/completion_service.proto

#include "google/cloud/discoveryengine/v1/completion_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CompletionServiceClient::CompletionServiceClient(
    std::shared_ptr<CompletionServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CompletionServiceClient::~CompletionServiceClient() = default;

StatusOr<google::cloud::discoveryengine::v1::CompleteQueryResponse>
CompletionServiceClient::CompleteQuery(
    google::cloud::discoveryengine::v1::CompleteQueryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CompleteQuery(request);
}

future<StatusOr<google::cloud::discoveryengine::v1::
                    ImportSuggestionDenyListEntriesResponse>>
CompletionServiceClient::ImportSuggestionDenyListEntries(
    google::cloud::discoveryengine::v1::
        ImportSuggestionDenyListEntriesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportSuggestionDenyListEntries(request);
}

StatusOr<google::longrunning::Operation>
CompletionServiceClient::ImportSuggestionDenyListEntries(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::
        ImportSuggestionDenyListEntriesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportSuggestionDenyListEntries(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::
                    ImportSuggestionDenyListEntriesResponse>>
CompletionServiceClient::ImportSuggestionDenyListEntries(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportSuggestionDenyListEntries(operation);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::PurgeSuggestionDenyListEntriesResponse>>
CompletionServiceClient::PurgeSuggestionDenyListEntries(
    google::cloud::discoveryengine::v1::
        PurgeSuggestionDenyListEntriesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeSuggestionDenyListEntries(request);
}

StatusOr<google::longrunning::Operation>
CompletionServiceClient::PurgeSuggestionDenyListEntries(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::
        PurgeSuggestionDenyListEntriesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeSuggestionDenyListEntries(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::PurgeSuggestionDenyListEntriesResponse>>
CompletionServiceClient::PurgeSuggestionDenyListEntries(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeSuggestionDenyListEntries(operation);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::ImportCompletionSuggestionsResponse>>
CompletionServiceClient::ImportCompletionSuggestions(
    google::cloud::discoveryengine::v1::
        ImportCompletionSuggestionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportCompletionSuggestions(request);
}

StatusOr<google::longrunning::Operation>
CompletionServiceClient::ImportCompletionSuggestions(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::
        ImportCompletionSuggestionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportCompletionSuggestions(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::ImportCompletionSuggestionsResponse>>
CompletionServiceClient::ImportCompletionSuggestions(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportCompletionSuggestions(operation);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::PurgeCompletionSuggestionsResponse>>
CompletionServiceClient::PurgeCompletionSuggestions(
    google::cloud::discoveryengine::v1::PurgeCompletionSuggestionsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeCompletionSuggestions(request);
}

StatusOr<google::longrunning::Operation>
CompletionServiceClient::PurgeCompletionSuggestions(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::PurgeCompletionSuggestionsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeCompletionSuggestions(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::discoveryengine::v1::PurgeCompletionSuggestionsResponse>>
CompletionServiceClient::PurgeCompletionSuggestions(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeCompletionSuggestions(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
