// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/uptime_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_UPTIME_CHECK_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_UPTIME_CHECK_CLIENT_H

#include "google/cloud/monitoring/v3/uptime_check_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The UptimeCheckService API is used to manage (list, create, delete, edit)
/// Uptime check configurations in the Cloud Monitoring product. An Uptime
/// check is a piece of configuration that determines which resources and
/// services to monitor for availability. These configurations can also be
/// configured interactively by navigating to the [Cloud console]
/// (https://console.cloud.google.com), selecting the appropriate project,
/// clicking on "Monitoring" on the left-hand side to navigate to Cloud
/// Monitoring, and then clicking on "Uptime".
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class UptimeCheckServiceClient {
 public:
  explicit UptimeCheckServiceClient(
      std::shared_ptr<UptimeCheckServiceConnection> connection,
      Options opts = {});
  ~UptimeCheckServiceClient();

  ///@{
  /// @name Copy and move support
  UptimeCheckServiceClient(UptimeCheckServiceClient const&) = default;
  UptimeCheckServiceClient& operator=(UptimeCheckServiceClient const&) =
      default;
  UptimeCheckServiceClient(UptimeCheckServiceClient&&) = default;
  UptimeCheckServiceClient& operator=(UptimeCheckServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(UptimeCheckServiceClient const& a,
                         UptimeCheckServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(UptimeCheckServiceClient const& a,
                         UptimeCheckServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists the existing valid Uptime check configurations for the project
  /// (leaving out any invalid configurations).
  ///
  /// @param parent  Required. The
  ///  [project](https://cloud.google.com/monitoring/api/v3#project_name) whose
  ///  Uptime check configurations are listed. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.UptimeCheckConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListUptimeCheckConfigsRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L113}
  /// [google.monitoring.v3.UptimeCheckConfig]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L123}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::UptimeCheckConfig> ListUptimeCheckConfigs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the existing valid Uptime check configurations for the project
  /// (leaving out any invalid configurations).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.ListUptimeCheckConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.UptimeCheckConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListUptimeCheckConfigsRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L113}
  /// [google.monitoring.v3.UptimeCheckConfig]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L123}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::UptimeCheckConfig> ListUptimeCheckConfigs(
      google::monitoring::v3::ListUptimeCheckConfigsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a single Uptime check configuration.
  ///
  /// @param name  Required. The Uptime check configuration to retrieve. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.UptimeCheckConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.GetUptimeCheckConfigRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L163}
  /// [google.monitoring.v3.UptimeCheckConfig]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L123}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::UptimeCheckConfig> GetUptimeCheckConfig(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a single Uptime check configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.GetUptimeCheckConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.UptimeCheckConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.GetUptimeCheckConfigRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L163}
  /// [google.monitoring.v3.UptimeCheckConfig]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L123}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::UptimeCheckConfig> GetUptimeCheckConfig(
      google::monitoring::v3::GetUptimeCheckConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Uptime check configuration.
  ///
  /// @param parent  Required. The
  ///  [project](https://cloud.google.com/monitoring/api/v3#project_name) in which
  ///  to create the Uptime check. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param uptime_check_config  Required. The new Uptime check configuration.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.UptimeCheckConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateUptimeCheckConfigRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L176}
  /// [google.monitoring.v3.UptimeCheckConfig]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L123}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::UptimeCheckConfig> CreateUptimeCheckConfig(
      std::string const& parent,
      google::monitoring::v3::UptimeCheckConfig const& uptime_check_config,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Uptime check configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.CreateUptimeCheckConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.UptimeCheckConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.CreateUptimeCheckConfigRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L176}
  /// [google.monitoring.v3.UptimeCheckConfig]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L123}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::UptimeCheckConfig> CreateUptimeCheckConfig(
      google::monitoring::v3::CreateUptimeCheckConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an Uptime check configuration. You can either replace the entire
  /// configuration with a new one or replace only certain fields in the current
  /// configuration by specifying the fields to be updated via `updateMask`.
  /// Returns the updated configuration.
  ///
  /// @param uptime_check_config  Required. If an `updateMask` has been specified, this field gives
  ///  the values for the set of fields mentioned in the `updateMask`. If an
  ///  `updateMask` has not been given, this Uptime check configuration replaces
  ///  the current configuration. If a field is mentioned in `updateMask` but
  ///  the corresponding field is omitted in this partial Uptime check
  ///  configuration, it has the effect of deleting/clearing the field from the
  ///  configuration on the server.
  ///  @n
  ///  The following fields can be updated: `display_name`,
  ///  `http_check`, `tcp_check`, `timeout`, `content_matchers`, and
  ///  `selected_regions`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.UptimeCheckConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.UpdateUptimeCheckConfigRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L195}
  /// [google.monitoring.v3.UptimeCheckConfig]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L123}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::UptimeCheckConfig> UpdateUptimeCheckConfig(
      google::monitoring::v3::UptimeCheckConfig const& uptime_check_config,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an Uptime check configuration. You can either replace the entire
  /// configuration with a new one or replace only certain fields in the current
  /// configuration by specifying the fields to be updated via `updateMask`.
  /// Returns the updated configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.UpdateUptimeCheckConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.monitoring.v3.UptimeCheckConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.UpdateUptimeCheckConfigRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L195}
  /// [google.monitoring.v3.UptimeCheckConfig]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L123}
  ///
  // clang-format on
  StatusOr<google::monitoring::v3::UptimeCheckConfig> UpdateUptimeCheckConfig(
      google::monitoring::v3::UpdateUptimeCheckConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an Uptime check configuration. Note that this method will fail
  /// if the Uptime check configuration is referenced by an alert policy or
  /// other dependent configs that would be rendered invalid by the deletion.
  ///
  /// @param name  Required. The Uptime check configuration to delete. The format is:
  ///  @n
  ///      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.DeleteUptimeCheckConfigRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L218}
  ///
  // clang-format on
  Status DeleteUptimeCheckConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an Uptime check configuration. Note that this method will fail
  /// if the Uptime check configuration is referenced by an alert policy or
  /// other dependent configs that would be rendered invalid by the deletion.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.DeleteUptimeCheckConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.DeleteUptimeCheckConfigRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L218}
  ///
  // clang-format on
  Status DeleteUptimeCheckConfig(
      google::monitoring::v3::DeleteUptimeCheckConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the list of IP addresses that checkers run from
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.monitoring.v3.ListUptimeCheckIpsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.monitoring.v3.UptimeCheckIp], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.monitoring.v3.ListUptimeCheckIpsRequest]: @googleapis_reference_link{google/monitoring/v3/uptime_service.proto#L231}
  /// [google.monitoring.v3.UptimeCheckIp]: @googleapis_reference_link{google/monitoring/v3/uptime.proto#L566}
  ///
  // clang-format on
  StreamRange<google::monitoring::v3::UptimeCheckIp> ListUptimeCheckIps(
      google::monitoring::v3::ListUptimeCheckIpsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<UptimeCheckServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_UPTIME_CHECK_CLIENT_H
