// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/user_event_service.proto

#include "google/cloud/retail/v2/internal/user_event_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

UserEventServiceTracingConnection::UserEventServiceTracingConnection(
    std::shared_ptr<retail_v2::UserEventServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::retail::v2::UserEvent>
UserEventServiceTracingConnection::WriteUserEvent(
    google::cloud::retail::v2::WriteUserEventRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::WriteUserEvent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->WriteUserEvent(request));
}

StatusOr<google::api::HttpBody>
UserEventServiceTracingConnection::CollectUserEvent(
    google::cloud::retail::v2::CollectUserEventRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::CollectUserEvent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CollectUserEvent(request));
}

future<StatusOr<google::cloud::retail::v2::PurgeUserEventsResponse>>
UserEventServiceTracingConnection::PurgeUserEvents(
    google::cloud::retail::v2::PurgeUserEventsRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::PurgeUserEvents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeUserEvents(request));
}

StatusOr<google::longrunning::Operation>
UserEventServiceTracingConnection::PurgeUserEvents(
    NoAwaitTag,
    google::cloud::retail::v2::PurgeUserEventsRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::PurgeUserEvents");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PurgeUserEvents(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::retail::v2::PurgeUserEventsResponse>>
UserEventServiceTracingConnection::PurgeUserEvents(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::PurgeUserEvents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeUserEvents(operation));
}

future<StatusOr<google::cloud::retail::v2::ImportUserEventsResponse>>
UserEventServiceTracingConnection::ImportUserEvents(
    google::cloud::retail::v2::ImportUserEventsRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::ImportUserEvents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ImportUserEvents(request));
}

StatusOr<google::longrunning::Operation>
UserEventServiceTracingConnection::ImportUserEvents(
    NoAwaitTag,
    google::cloud::retail::v2::ImportUserEventsRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::ImportUserEvents");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->ImportUserEvents(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::retail::v2::ImportUserEventsResponse>>
UserEventServiceTracingConnection::ImportUserEvents(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::ImportUserEvents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ImportUserEvents(operation));
}

future<StatusOr<google::cloud::retail::v2::RejoinUserEventsResponse>>
UserEventServiceTracingConnection::RejoinUserEvents(
    google::cloud::retail::v2::RejoinUserEventsRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::RejoinUserEvents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RejoinUserEvents(request));
}

StatusOr<google::longrunning::Operation>
UserEventServiceTracingConnection::RejoinUserEvents(
    NoAwaitTag,
    google::cloud::retail::v2::RejoinUserEventsRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::RejoinUserEvents");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RejoinUserEvents(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::retail::v2::RejoinUserEventsResponse>>
UserEventServiceTracingConnection::RejoinUserEvents(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "retail_v2::UserEventServiceConnection::RejoinUserEvents");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RejoinUserEvents(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<retail_v2::UserEventServiceConnection>
MakeUserEventServiceTracingConnection(
    std::shared_ptr<retail_v2::UserEventServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<UserEventServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google
