/*************************************************************************
 *    Copyright (C) 2008 Christian Kuka <ckuka@madkooky.de>
 *
 *    This file is part of PQStego.
 *
 *    PQStego is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    PQStego is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *************************************************************************/

#ifndef _JPEG_H
#define	_JPEG_H

#ifdef	__cplusplus
extern "C" {
#endif
    
#include <math.h>
#include <pqstego/pq.h>

    typedef struct {
        struct jpeg_compress_struct *compress;
        struct jpeg_decompress_struct *decompress;
    } jpeg_internal_data_t;

    uint32_t pq_read_jpeg(const uint8_t *filename, pq_data_t *jpeg_data, jpeg_internal_data_t *jpeg_internal);

    uint32_t pq_write_jpeg(const uint8_t *filename, pq_data_t *jpeg_data, jpeg_internal_data_t *jpeg_internal);

#ifdef	__cplusplus
}
#endif

#endif	/* _JPEG_H */

