#include <stdio.h>
#include <string.h>
#include "vars.h"


 /*****************************************************************
  *    http://sub.sub.sub.domen2levelname.ru:4543/dir/dir/file   *
  *    |     |           |                  |    |            |   *
  * protocol | subdomen  |   twoleveldomen  |port|    dirs    |   *
  *           |                            /     |                *
  *         proto                      port   separator           *
  *****************************************************************/

int parse_urls(struct p_url *t_url,char *url)
{
 char *k,*proto,*separator,*port;
 int len,i;

 port=0;
 #ifdef DEBUG_PARSE_URL
 fprintf(stderr,"\n=== Parse url: %s ===\n",url);
 #endif

 // Extract protocol
 k=strstr(url,"://");
  if (!k)
  {
   t_url->protocol[0]=0;
   #ifdef DEBUG_PARSE_URL
   fprintf(stderr,"  protocol: none\n");
   #endif
  }
 else
  {
   len=k-url;
   if (len+3>=strlen(url)) {return(-1);}
   if (len>=ML_PROTOKOL) return(-1);
   memcpy(t_url->protocol,url,len);
   t_url->protocol[len]=0;
   #ifdef DEBUG_PARSE_URL
   fprintf(stderr,"  protocol: %s\n",t_url->protocol);
   #endif
  }

  // Set proto
  if (!k) proto=url;
  else    proto=k+3;

//   printf("     proto: %i (%c)\n",proto-url,*proto);


  // Set separator
  separator=strchr(proto,'/');
  if (!separator) separator=url+strlen(url);
  #ifdef DEBUG_PARSE_URL
  fprintf(stderr," separator: %i \tSymbol:%c (%i)\n",separator-url,*separator,*separator);
  #endif

 if (separator==url) return(-1);
 if(separator==proto) return(-1);

 //Shift proto to '@' symbol (if exist)
  for(k=separator;k>proto;k--)
  {
   if (*k=='@')
     {
      proto=k+1;
      break;
     }
  }

 // Extract dirs
 if (!*separator)
  {
   t_url->dirs[0]=0;
   #ifdef DEBUG_PARSE_URL
    fprintf(stderr,"      dirs: none\n");
   #endif
  }
 else
  {
   len=(url+strlen(url)-separator);
   if (len>ML_DIRS) return(-1);
   memcpy(t_url->dirs,separator,len);
   t_url->dirs[len]=0;
   #ifdef DEBUG_PARSE_URL
    fprintf(stderr,"      dirs: %s\n",t_url->dirs);
   #endif
  }

 // Extract port
 for(k=separator-1;k>proto;k--)
 {
  if (*k==':')
   {
    port=k;
    k++;
    len=separator-k;
    if (len>ML_PORT) return(-1);
    memcpy(t_url->port,k,len);
    t_url->port[len]=0;
    #ifdef DEBUG_PARSE_URL
    fprintf(stderr,"      port: %s\n",t_url->port);
    #endif
    break;
   }
   // 0123456789
   if (*k<48 || *k>57)
    {
     t_url->port[0]=0;
     port=separator;
     #ifdef DEBUG_PARSE_URL
     fprintf(stderr,"      port: none\n");
     #endif
     break;
    }
 } // extract port cycle
 if (k==proto)
    {
     t_url->port[0]=0;
     port=separator;
     #ifdef DEBUG_PARSE_URL
     fprintf(stderr,"      port: none (Bad url?)\n");
     #endif
    }


 // Extract  2 level domen
 i=0; // '.' counter

 for(k=port-1;k>=proto;k--)
 {
  if (*k=='.') i++;
  if (i>1)
   {
    k++;
    len=port-k;
    if (len>=ML_2LD) return(-1);
    memcpy(t_url->twoleveldomen,k,len);
    t_url->twoleveldomen[len]=0;
    #ifdef DEBUG_PARSE_URL
    fprintf(stderr,"2levdlomen: %s\n",t_url->twoleveldomen);
    #endif
    break;
   }
 else if (k==proto)
   {
    len=port-k;
    if (len>=ML_2LD) return(-1);
    memcpy(t_url->twoleveldomen,k,len);
    t_url->twoleveldomen[len]=0;
    #ifdef DEBUG_PARSE_URL
    fprintf(stderr,"2levdlomen: %s\n",t_url->twoleveldomen);
    #endif
    break;
   }
 } //extract 2 level domen cycle

 // Extract subdomen;
 if (k==proto)
    {
     t_url->subdomen[0]=0;
     #ifdef DEBUG_PARSE_URL
     fprintf(stderr,"  subdomen: none\n");
     #endif
    }
 else
    {

     len=k-proto-1;
     if (len>=ML_SUBDOMEN) return(-1);
     memcpy(t_url->subdomen,proto,len);
     t_url->subdomen[len]=0;
     #ifdef DEBUG_PARSE_URL
     fprintf(stderr,"  subdomen: %s\n",t_url->subdomen);
     #endif
    }
 return(0);
}
