// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/connectors/v1/destination_config.proto

package connectors

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Define the Connectors target endpoint.
type DestinationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key is the destination identifier that is supported by the Connector.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The destinations for the key.
	Destinations []*Destination `protobuf:"bytes,2,rep,name=destinations,proto3" json:"destinations,omitempty"`
}

func (x *DestinationConfig) Reset() {
	*x = DestinationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_destination_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationConfig) ProtoMessage() {}

func (x *DestinationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_destination_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationConfig.ProtoReflect.Descriptor instead.
func (*DestinationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_destination_config_proto_rawDescGZIP(), []int{0}
}

func (x *DestinationConfig) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *DestinationConfig) GetDestinations() []*Destination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

type Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Destination:
	//
	//	*Destination_ServiceAttachment
	//	*Destination_Host
	Destination isDestination_Destination `protobuf_oneof:"destination"`
	// The port is the target port number that is accepted by the destination.
	Port int32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *Destination) Reset() {
	*x = Destination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_destination_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Destination) ProtoMessage() {}

func (x *Destination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_destination_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Destination.ProtoReflect.Descriptor instead.
func (*Destination) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_destination_config_proto_rawDescGZIP(), []int{1}
}

func (m *Destination) GetDestination() isDestination_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *Destination) GetServiceAttachment() string {
	if x, ok := x.GetDestination().(*Destination_ServiceAttachment); ok {
		return x.ServiceAttachment
	}
	return ""
}

func (x *Destination) GetHost() string {
	if x, ok := x.GetDestination().(*Destination_Host); ok {
		return x.Host
	}
	return ""
}

func (x *Destination) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

type isDestination_Destination interface {
	isDestination_Destination()
}

type Destination_ServiceAttachment struct {
	// PSC service attachments.
	// Format: projects/*/regions/*/serviceAttachments/*
	ServiceAttachment string `protobuf:"bytes,1,opt,name=service_attachment,json=serviceAttachment,proto3,oneof"`
}

type Destination_Host struct {
	// For publicly routable host.
	Host string `protobuf:"bytes,2,opt,name=host,proto3,oneof"`
}

func (*Destination_ServiceAttachment) isDestination_Destination() {}

func (*Destination_Host) isDestination_Destination() {}

var File_google_cloud_connectors_v1_destination_config_proto protoreflect.FileDescriptor

var file_google_cloud_connectors_v1_destination_config_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76,
	0x31, 0x22, 0x72, 0x0a, 0x11, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4b, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x77, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x42,
	0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x48,
	0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_connectors_v1_destination_config_proto_rawDescOnce sync.Once
	file_google_cloud_connectors_v1_destination_config_proto_rawDescData = file_google_cloud_connectors_v1_destination_config_proto_rawDesc
)

func file_google_cloud_connectors_v1_destination_config_proto_rawDescGZIP() []byte {
	file_google_cloud_connectors_v1_destination_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_connectors_v1_destination_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_connectors_v1_destination_config_proto_rawDescData)
	})
	return file_google_cloud_connectors_v1_destination_config_proto_rawDescData
}

var file_google_cloud_connectors_v1_destination_config_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_connectors_v1_destination_config_proto_goTypes = []interface{}{
	(*DestinationConfig)(nil), // 0: google.cloud.connectors.v1.DestinationConfig
	(*Destination)(nil),       // 1: google.cloud.connectors.v1.Destination
}
var file_google_cloud_connectors_v1_destination_config_proto_depIdxs = []int32{
	1, // 0: google.cloud.connectors.v1.DestinationConfig.destinations:type_name -> google.cloud.connectors.v1.Destination
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_connectors_v1_destination_config_proto_init() }
func file_google_cloud_connectors_v1_destination_config_proto_init() {
	if File_google_cloud_connectors_v1_destination_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_connectors_v1_destination_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_destination_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Destination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_connectors_v1_destination_config_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Destination_ServiceAttachment)(nil),
		(*Destination_Host)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_connectors_v1_destination_config_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_connectors_v1_destination_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_connectors_v1_destination_config_proto_depIdxs,
		MessageInfos:      file_google_cloud_connectors_v1_destination_config_proto_msgTypes,
	}.Build()
	File_google_cloud_connectors_v1_destination_config_proto = out.File
	file_google_cloud_connectors_v1_destination_config_proto_rawDesc = nil
	file_google_cloud_connectors_v1_destination_config_proto_goTypes = nil
	file_google_cloud_connectors_v1_destination_config_proto_depIdxs = nil
}
