/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictException;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class LatestCompatibleConflictManager
extends LatestConflictManager {
    public LatestCompatibleConflictManager() {
    }

    public LatestCompatibleConflictManager(String string, LatestStrategy latestStrategy) {
        super(string, latestStrategy);
    }

    @Override
    public Collection resolveConflicts(IvyNode ivyNode, Collection collection) {
        Iterator iterator;
        IvyNode ivyNode2;
        ModuleRevisionId moduleRevisionId;
        if (collection.size() < 2) {
            return collection;
        }
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        if (versionMatcher.isDynamic(moduleRevisionId = (ivyNode2 = (IvyNode)(iterator = collection.iterator()).next()).getResolvedId())) {
            Object object;
            while (iterator.hasNext()) {
                object = (IvyNode)iterator.next();
                if (versionMatcher.isDynamic(((IvyNode)object).getResolvedId())) {
                    return null;
                }
                if (versionMatcher.accept(moduleRevisionId, ((IvyNode)object).getResolvedId()) || this.handleIncompatibleConflict(ivyNode, collection, ivyNode2, (IvyNode)object)) continue;
                return null;
            }
            if (collection.size() == 2) {
                object = collection.iterator();
                object.next();
                return Collections.singleton(object.next());
            }
            object = new LinkedHashSet(collection);
            object.remove(ivyNode2);
            return super.resolveConflicts(ivyNode, (Collection)object);
        }
        while (iterator.hasNext()) {
            IvyNode ivyNode3 = (IvyNode)iterator.next();
            if (versionMatcher.accept(ivyNode3.getResolvedId(), moduleRevisionId) || this.handleIncompatibleConflict(ivyNode, collection, ivyNode2, ivyNode3)) continue;
            return null;
        }
        return Collections.singleton(ivyNode2);
    }

    private boolean handleIncompatibleConflict(IvyNode ivyNode, Collection collection, IvyNode ivyNode2, IvyNode ivyNode3) {
        try {
            Object object = (LatestConflictManager.IvyNodeArtifactInfo)this.getStrategy().findLatest(this.toArtifactInfo(Arrays.asList(ivyNode2, ivyNode3)), null);
            if (object != null) {
                IvyNode ivyNode4 = (object = ((LatestConflictManager.IvyNodeArtifactInfo)object).getNode()) == ivyNode2 ? ivyNode3 : ivyNode2;
                LatestCompatibleConflictManager latestCompatibleConflictManager = this;
                latestCompatibleConflictManager.blackListIncompatibleCallerAndRestartResolveIfPossible(latestCompatibleConflictManager.getSettings(), ivyNode, ivyNode4, (IvyNode)object);
                LatestCompatibleConflictManager latestCompatibleConflictManager2 = this;
                latestCompatibleConflictManager2.blackListIncompatibleCallerAndRestartResolveIfPossible(latestCompatibleConflictManager2.getSettings(), ivyNode, (IvyNode)object, ivyNode4);
                this.handleUnsolvableConflict(ivyNode, collection, ivyNode2, ivyNode3);
                return true;
            }
            return false;
        }
        catch (LatestConflictManager.NoConflictResolvedYetException noConflictResolvedYetException) {
            return false;
        }
    }

    private void blackListIncompatibleCallerAndRestartResolveIfPossible(IvySettings ivySettings, IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3) {
        Object object = new Stack<IvyNode>();
        ((Stack)object).push(ivyNode3);
        object = this.blackListIncompatibleCaller(ivySettings.getVersionMatcher(), ivyNode, ivyNode2, ivyNode3, (Stack)object);
        if (object != null) {
            StringBuffer stringBuffer = new StringBuffer();
            object = object.iterator();
            while (object.hasNext()) {
                IvyNodeBlacklist ivyNodeBlacklist = (IvyNodeBlacklist)object.next();
                ivyNodeBlacklist.getBlacklistedNode().blacklist(ivyNodeBlacklist);
                stringBuffer.append(ivyNodeBlacklist.getBlacklistedNode());
                if (!object.hasNext()) continue;
                stringBuffer.append(" ");
            }
            object = ivyNode.getData().getReport().getConfiguration();
            ivyNode3.markEvicted(new IvyNodeEviction.EvictionData((String)object, ivyNode, this, Collections.singleton(ivyNode2), "with blacklisting of " + stringBuffer));
            if (ivySettings.debugConflictResolution()) {
                Message.debug("evicting " + ivyNode3 + " by " + ivyNode3.getEvictedData((String)object));
            }
            throw new RestartResolveProcess("trying to handle incompatibilities between " + ivyNode2 + " and " + ivyNode3);
        }
    }

    private boolean handleIncompatibleCaller(Stack stack, IvyNode object, IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3, IvyNode ivyNode4, Collection collection, VersionMatcher versionMatcher) {
        if (stack.subList(0, stack.size() - 1).contains(object)) {
            return true;
        }
        stack.push(ivyNode);
        object = this.blackListIncompatibleCaller(versionMatcher, ivyNode2, ivyNode3, ivyNode4, stack);
        stack.pop();
        if (object == null) {
            return false;
        }
        collection.addAll(object);
        return true;
    }

    private Collection blackListIncompatibleCaller(VersionMatcher versionMatcher, IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3, Stack stack) {
        ArrayList<IvyNodeBlacklist> arrayList = new ArrayList<IvyNodeBlacklist>();
        IvyNode ivyNode4 = (IvyNode)stack.peek();
        String string = ivyNode.getData().getReport().getConfiguration();
        IvyNodeCallers.Caller[] callerArray = ivyNode4.getCallers(string);
        for (int i = 0; i < callerArray.length; ++i) {
            IvyNode ivyNode5 = ivyNode4.findNode(callerArray[i].getModuleRevisionId());
            if (ivyNode5.isBlacklisted(string)) continue;
            if (versionMatcher.isDynamic(callerArray[i].getAskedDependencyId(ivyNode4.getData()))) {
                arrayList.add(new IvyNodeBlacklist(ivyNode, ivyNode2, ivyNode3, ivyNode4, string));
                if (!ivyNode4.isEvicted(string) || this.handleIncompatibleCaller(stack, ivyNode4, ivyNode5, ivyNode, ivyNode2, ivyNode3, arrayList, versionMatcher)) continue;
                return null;
            }
            if (this.handleIncompatibleCaller(stack, ivyNode4, ivyNode5, ivyNode, ivyNode2, ivyNode3, arrayList, versionMatcher)) continue;
            return null;
        }
        if (arrayList.isEmpty() && !stack.subList(0, stack.size() - 1).contains(ivyNode4)) {
            return null;
        }
        return arrayList;
    }

    protected void handleUnsolvableConflict(IvyNode ivyNode, Collection collection, IvyNode ivyNode2, IvyNode ivyNode3) {
        throw new StrictConflictException(ivyNode2, ivyNode3);
    }

    @Override
    public void handleAllBlacklistedRevisions(DependencyDescriptor object, Collection iterator) {
        Object object2;
        object = IvyContext.getContext().getResolveData();
        Object object3 = new HashSet<IvyNode>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object2 = (ModuleRevisionId)iterator.next();
            object3.add(((ResolveData)object).getNode((ModuleRevisionId)object2));
        }
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (IvyNode)iterator.next();
            object3 = ((IvyNode)object2).getBlacklistData(((ResolveData)object).getReport().getConfiguration());
            this.handleUnsolvableConflict(((IvyNodeBlacklist)object3).getConflictParent(), Arrays.asList(((IvyNodeBlacklist)object3).getEvictedNode(), ((IvyNodeBlacklist)object3).getSelectedNode()), ((IvyNodeBlacklist)object3).getEvictedNode(), ((IvyNodeBlacklist)object3).getSelectedNode());
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

