/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.SdkToolsLocator;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import java.nio.file.Path;
import java.util.Optional;

final class CommandUtils {
    static final String ANDROID_SERIAL_VARIABLE = "ANDROID_SERIAL";

    private CommandUtils() {
    }

    static Path getAdbPath(ParsedFlags flags, Flag<Path> adbFlag, SystemEnvironmentProvider systemEnvironmentProvider) {
        return adbFlag.getValue(flags).orElseGet(() -> new SdkToolsLocator().locateAdb(systemEnvironmentProvider).orElseThrow(() -> CommandExecutionException.builder().withInternalMessage("Unable to determine the location of ADB. Please set the --adb flag or define ANDROID_HOME or PATH environment variable.").build()));
    }

    static Optional<String> getDeviceSerialName(ParsedFlags flags, Flag<String> deviceIdFlag, SystemEnvironmentProvider systemEnvironmentProvider) {
        Optional<String> deviceSerialName = deviceIdFlag.getValue(flags);
        if (!deviceSerialName.isPresent()) {
            deviceSerialName = systemEnvironmentProvider.getVariable(ANDROID_SERIAL_VARIABLE);
        }
        return deviceSerialName;
    }

    static Aapt2Command extractAapt2FromJar(Path tempDir) {
        return new SdkToolsLocator().extractAapt2(tempDir).map(Aapt2Command::createFromExecutablePath).orElseThrow(() -> CommandExecutionException.builder().withInternalMessage("Could not extract aapt2: consider updating bundletool to a more recent version or providing the path to aapt2 using the flag --aapt2.").build());
    }
}

