/*
  File: list.c

  Copyright (C) 2007
  Marcin 'Morgoth' Kurek <morgoth6@box43.pl>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "bootcreator.h"
#include "list.h"

/*
 * NewList
 */

void new_list(struct List *list)
{

	list->TailPred = (struct Node *) list;
	list->Tail = (struct Node *) NULL;
	list->Head = (struct Node *) &list->Tail;

	/* End */
	return;
}

/*
 * AddHead
 */

void add_node(struct List *list, struct Node *node)
{
	node->Succ = (struct Node *) &list->Tail;
	node->Pred = list->TailPred;
	list->TailPred->Succ = node;
	list->TailPred = node;

	/* End */
	return;
}

/*
 * Remove
 */

struct Node *remove_node(struct Node *node)
{
	struct Node *p_node = node->Pred;
	struct Node *s_node = node->Succ;

	p_node->Succ = s_node;
	s_node->Pred = p_node;

	/* End */
	return (node);
}
