#include "gimme_config_h.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#include "cddb_hearken.h"
#include "cdstatus_cddb.h"
#include "cdstatus_output.h"

int hearken(int client_sock, void *buffer)
{
	ssize_t data_size;
	int result;

	memset(buffer, 0, BUFFSIZE);
	data_size = recv(client_sock, buffer, BUFFSIZE - 1, 0);
	if (data_size == -1)
	{
		conditional_perror(WARNING, "Error while receiving data from cddb site. Aborting Lookup");
		return -1;
	}
	else
	{
		conditional_printf(VERBOSE_DEBUG, "Received %d bytes of data from server: \n%s\n", data_size, (char *) buffer);
	}

	if(sscanf((const char *) buffer, "%d", &result)!=1)
	{
		conditional_puts(CRITICAL, "Error parsing/matching input, exiting.");
		exit(EXIT_FAILURE);
	}
	return result;
}
