# ruby-prism-sys

Rust bindings to [ruby/prism](https://github.com/ruby/prism)'s C API.

## Examples

Currently the best examples are found in the integration tests (in `tests/`).

## Documentation

Since this crate has not been released, docs are not yet online anywhere. You can generate them,
however, from this directory in this repo by running `cargo doc`, then opening
`target/doc/ruby_prism_sys/index.html` in your browser. (You could, instead, combine those two steps by
doing `cargo doc --open`!)

## Development

### Dependencies

In addition to the Ruby prism dependencies, you shouldn't need anything else besides Rust.

### Updating bindings

`build.rs` (which gets called as part of running `cargo build`, `cargo test`, etc) is where we tell
`bindgen` which types, functions, etc. that we want it to generate for us. It's smart enough to know
to generate dependencies for items we specify in there (ex. `pm_parser_t` has fields of type
`pm_token_t`, but we don't need to tell `bindgen` about `pm_token_t`--it'll figure it out and
generate bindings for that type too).

If you want to generate new bindings, update `build.rs` accordingly, then run `cargo doc` and check
the docs; that should tell you if `bindgen` generated all the things you need or not.

### Testing

Since almost all of the code is generated by the well-tested
[`bindgen`](https://github.com/rust-lang/rust-bindgen) crate, we only have some cursory integration
tests in `tests/`, really just validating types and functions got generated appropriately. (They
also give some hints about how to use the API from Rust!) To run the tests, run `cargo test`.

Any new publicly exposed C API additions should get a test or two.
