// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

namespace Gdmt.Sync.Runners

module Git =
    open SimpleLog.SimpleLog

    open Gdmt.Shared

    let RunGitPull (pullRemote: string) : unit =
        let gitArgs = [ "git"; "pull"; pullRemote ]

        LogMessage Debug $"Pulling from remote {pullRemote}"
        ExecProcess(gitArgs).Run().Check()
        LogMessage Success $"Pull from {pullRemote} succeeded"

    let RunGitPush (gitRemote: string) (sign: bool) : unit =
        let gitArgs = [ "git"; "push"; gitRemote ] @ if sign then [ "--sign" ] else []

        LogMessage Debug $"Pushing to remote: {gitRemote}"
        ExecProcess(gitArgs).Run().Check()
        LogMessage Success $"Push to {gitRemote} succeeded"

    let RunGitRefresh () : unit =
        let gitArgs = [ "git"; "update-index"; "--refresh" ]

        LogMessage Debug "Refreshing the git repository index"
        ExecProcess(gitArgs).Run().Check()
        LogMessage Success "Refresh succeeded"

    let RunGitGC () : unit =
        let gitArgs = [ "git"; "gc"; "--aggressive" ]

        LogMessage Debug "Performing garbage collection"
        ExecProcess(gitArgs).Run().Check()
        LogMessage Success "Garbage collection succeeded"
