/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.io.IOException;
import java.time.Duration;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;

public class OriginMetadataSerializer
extends AbstractSerializer<OriginMetadata> {
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

    public OriginMetadata read(Decoder decoder) throws IOException {
        String buildInvocationId = decoder.readString();
        HashCode buildCacheKey = this.hashCodeSerializer.read(decoder);
        Duration executionTime = Duration.ofMillis(decoder.readSmallLong());
        return new OriginMetadata(buildInvocationId, buildCacheKey, executionTime);
    }

    public void write(Encoder encoder, OriginMetadata originMetadata) throws IOException {
        encoder.writeString((CharSequence)originMetadata.getBuildInvocationId());
        this.hashCodeSerializer.write(encoder, originMetadata.getBuildCacheKey());
        encoder.writeSmallLong(originMetadata.getExecutionTime().toMillis());
    }
}

