<?php
	// Project:    Web Reference Database (refbase) <http://www.refbase.net>
	// Copyright:  Matthias Steffens <mailto:refbase@extracts.de> and the file's
	//             original author(s).
	//
	//             This code is distributed in the hope that it will be useful,
	//             but WITHOUT ANY WARRANTY. Please see the GNU General Public
	//             License for more details.
	//
	// File:       ./initialize/ini.inc.php
	// Repository: $HeadURL: file:///svn/p/refbase/code/branches/bleeding-edge/initialize/ini.inc.php $
	// Author(s):  Matthias Steffens <mailto:refbase@extracts.de>
	//
	// Created:    12-Jan-03, 17:58
	// Modified:   $Date: 2016-11-06 01:55:25 +0000 (Sun, 06 Nov 2016) $
	//             $Author: karnesky $
	//             $Revision: 1413 $

	// This is the customization include file.
	// It contains variables that are common to all scripts and whose values can/should be customized.
	// I.e., you can adjust their values as needed but you must not change the variable names themselves!

	// --------------------------------------------------------------------

	// The official name of this literature database:
	$officialDatabaseName = "Your Literature Database"; // e.g. "IP Literature Database"


	// Specify who'll be allowed to add a new user to the users table:
	// Note, that you should leave this variable as it is, if you're going to use the 'install.php'
	// script and the provided database structure file ('install.sql') for installation. This variable
	// is only provided for people who want to install the refbase database manually (i.e. without using
	// 'install.php' & 'install.sql'). If so, setting this value to "everyone" enables you to add the
	// admin as the very first user (don't forget to specify his email address below!). Then, change the
	// value of $addNewUsers to "admin". By that you prevent other users from messing with your users
	// table. (If the value is set to "everyone", any user will be able to add users to the users table!)
	$addNewUsers = "admin"; // possible values: "everyone", "admin"


	// The admin email address (by which a user is granted admin status after successful login!):
	// Note that you must NOT change this email address unless you've already logged in and created your
	// own admin user! See the INSTALL file for instructions on how to setup your own admin user.
	$adminLoginEmail = "user@refbase.net"; // e.g. "admin@ipoe.uni-kiel.de"


	// The feedback email address to which any support questions or suggestions should be sent:
	$feedbackEmail = "FEEDBACK_EMAIL_ADDRESS"; // e.g. "admin@ipoe.uni-kiel.de"


	// The full name of the institution hosting this literature database:
	$hostInstitutionName = "Institute for ..."; // e.g. "Institute for Polar Ecology"


	// The abbreviated name of the institution hosting this literature database:
	$hostInstitutionAbbrevName = "..."; // e.g. "IP"


	// The URL of the institution hosting this literature database:
	$hostInstitutionURL = "INSTITUTION_WEB_ADDRESS"; // e.g. "http://www.uni-kiel.de/ipoe/"


	// The URL to any (custom) help resources for this literature database:
	// (specify an empty string if you don't want a help link: '$helpResourcesURL = "";')
	$helpResourcesURL = "http://www.refbase.net/"; // e.g. "http://www.refbase.net/"


	// Specify whether announcements should be sent to the email address given in '$mailingListEmail':
	// If $sendEmailAnnouncements = "yes", a short info will be mailed to the email address specified
	// in $mailingListEmail if a new record has been added to the database.
	$sendEmailAnnouncements = "no"; // possible values: "yes", "no"


	// The mailing list email address to which any announcements should be sent:
	$mailingListEmail = "ANNOUNCEMENT_EMAIL_ADDRESS"; // e.g. "ipoelit-announce@ipoe.uni-kiel.de"


	// The base URL for this literature database (i.e., the URL to the refbase root directory where
	// your refbase scripts are located):
	// It will be used within RSS feeds and when sending notification emails to database users.
	// The base URL is auto-generated by the code below. Enter a literal URL if this doesn't work for
	// you.
	$databaseBaseURL = preg_replace('#[^/]*$#','','http://'.$_SERVER['HTTP_HOST'].scriptURL(),1); // e.g. "http://polaris.ipoe.uni-kiel.de/refs/"


	// The keywords/tags that describe or categorize the content of this literature database:
	// These keywords/tags should be single words delimited by a space character. They'll be
	// included on every HTML page (in the <head> section) as well as in the OpenSearch description
	// document. A good selection of keywords may help to increase search engine visibility.
	$databaseKeywords = "science academic literature scientific references publication search citation web bibliography database mysql php refbase"; // e.g. "academic literature refbase"


	// The character encoding that's used as content-type for HTML, RSS and email output:
	// IMPORTANT NOTES: - the encoding type specified here must match the default character set you've
	//                    chosen on install for your refbase MySQL database & tables!
	//                  - plus, the character encoding of this file ('ini.inc.php') MUST match the
	//                    encoding type specified in '$contentTypeCharset'! This means, if you're going to
	//                    use "UTF-8", you must re-save this file with encoding "Unicode (UTF-8, no BOM)".
	$contentTypeCharset = "ISO-8859-1"; // possible values: "ISO-8859-1", "UTF-8"


	// In case you're using a latin1-encoded database ('$contentTypeCharset=ISO-8859-1'), specify whether
	// exported data (Bibtex/Endnote/RIS or MODS/SRW/ODF XML) shall be converted to Unicode (UTF-8, no BOM).
	// Conversion of exported data to UTF-8 ('$convertExportDataToUTF8=yes') is required to correctly convert
	// refbase markup such as super- and subscript or greek letters. If you set this variable to "no", then
	// the relevant refbase markup will not get converted for a latin1 database(*) and output will be in
	// ISO-8859-1 encoding.
	// (*: as a notable exception, conversion of refbase markup such as super- and subscript or greek letters
	//     will be done upon Bibtex export even if this variable is set to "no")
	$convertExportDataToUTF8 = "yes"; // possible values: "yes", "no"


	// The path to the default CSS stylesheet which will be used for all page views except print/mobile view:
	$defaultStyleSheet = "css/style.css"; // e.g. "css/style.css"

	// The path to the CSS stylesheet which will be used for print view:
	$printStyleSheet = "css/style_print.css"; // e.g. "css/style_print.css"

	// The path to the CSS stylesheet which will be used for mobile view (intended for mobile devices):
	$mobileStyleSheet = "css/style_mobile.css"; // e.g. "css/style_mobile.css"


	// The default interface language:
	$defaultLanguage = "en"; // possible values: "en", "de", "fr", "cn", or "ru"


	// The number of records that's returned by default:
	// Note that this setting also controls how many records will be returned by default for RSS, OpenSearch,
	// SRU and CLI queries.
	$defaultNumberOfRecords = 10;


	// The URL path to the main logo image that's displayed in the refbase header:
	// (note that all URL paths must be given relative to the root level of your refbase script directory)
	$logoImageURL = "img/logo.png"; // e.g. "img/logo.png"

	// The width of the main logo image (in pixels):
	$logoImageWidth = "94"; // e.g. "94"

	// The height of the main logo image (in pixels):
	$logoImageHeight = "94"; // e.g. "94"


	// The URL path to a small logo image (which gets used in the OpenSearch description document):
	// (when possible, supply a 64x64 image of type ".jpeg" or ".png" with a square aspect ratio)
	$logoSmallImageURL = "img/logo_small.png"; // e.g. "img/logo_small.png"

	// The width of the small logo image (in pixels):
	$logoSmallImageWidth = "64"; // e.g. "64"

	// The height of the small logo image (in pixels):
	$logoSmallImageHeight = "64"; // e.g. "64"

	// The valid MIME type of the small logo image:
	$logoSmallImageType = "image/png"; // e.g. "image/jpeg" or "image/png"


	// The URL path to a favicon image (which gets used in the OpenSearch description document):
	// (this must be a 16x16 image of type ".ico")
	$faviconImageURL = "img/favicon.ico"; // e.g. "img/favicon.ico"


	// Specify whether auto-completions (search suggestions) shall be provided
	// by default (via Ajax calls) for user input in text entry fields:
	$autoCompleteUserInput = "yes"; // possible values: "yes", "no"


	// Specify whether visual effects (such as a sliding effect) shall be used
	// when a user toggles the display of particular GUI sections (e.g. the
	// Search & Display Options above the search results list):
	$useVisualEffects = "yes"; // possible values: "yes", "no"


	// Defines the default user permissions when adding new users:
	// Possible values for each of the permission settings: "yes", "no"
	// Allow a newly created user to:
	$defaultUserPermissions = array("yes", // add records to the database ('allow_add')
	                                "yes", // edit records in the database ('allow_edit')
	                                "yes", // delete records from the database ('allow_delete')
	                                "yes", // download files which are associated with particular records ('allow_download')
	                                "yes", // upload files to the database ('allow_upload')
	                                "yes", // view records in list view ('allow_list_view')
	                                "yes", // view any record details ('allow_details_view')
	                                "yes", // view records in print view ('allow_print_view')
	                                "no", // view records in browse view ('allow_browse_view')
	                                "yes", // build a reference list from selected records ('allow_cite')
	                                "yes", // import records into the database ('allow_import')
	                                "yes", // batch import records into the database ('allow_batch_import')
	                                "yes", // export records from the database ('allow_export')
	                                "yes", // batch export records from the database ('allow_batch_export')
	                                "yes", // use the 'user groups' feature ('allow_user_groups')
	                                "yes", // use the 'user queries' feature ('allow_user_queries')
	                                "yes", // generate dynamic RSS feeds from any query ('allow_rss_feeds')
	                                "yes", // execute custom SQL queries via 'sql_search.php' ('allow_sql_search')
	                                "yes", // change his/her personal data (like name, address or password) ('allow_modify_options')
	                                "no"); // fully edit the contents of the 'call_number' field (like the database admin) ('allow_edit_call_number')
	                                       // [note that the 'allow_edit_call_number' permission setting isn't honoured yet!]


	// When adding a new user, the following export formats will be made available to the new user by default:
	// The specified format names must have matching entries within the 'formats' MySQL table.
	$defaultUserExportFormats = array("BibTeX",
	                                  "Endnote",
	                                  "ISI",
	                                  "RIS",
	                                  "MODS XML",
	                                  "ODF XML",
	                                  "Word XML");


	// When adding a new user, the following citation formats will be made available to the new user by default:
	// The specified format names must have matching entries within the 'formats' MySQL table.
	$defaultUserCiteFormats = array("html",
	                                "RTF",
	                                "PDF",
	                                "LaTeX");


	// When adding a new user, the following citation styles will be made available to the new user by default:
	// The specified citation styles must have matching entries within the 'styles' MySQL table.
	$defaultUserStyles = array("APA",
	                           "AMA",
	                           "MLA",
	                           "Chicago",
	                           "Harvard 1",
	                           "Harvard 2",
	                           "Harvard 3",
	                           "Vancouver",
	                           "Deep Sea Res",
	                           "J Glaciol",
	                           "Mar Biol",
	                           "Text Citation");


	// When adding a new user, the following reference types will be made available to the new user by default:
	// The specified reference types must have matching entries within the 'types' MySQL table.
	$defaultUserTypes = array("Journal Article",
	                          "Abstract",
	                          "Book Chapter",
	                          "Book Whole",
	                          "Conference Article",
	                          "Conference Volume",
	                          "Journal",
	                          "Magazine Article",
	                          "Manual",
	                          "Manuscript",
	                          "Map",
	                          "Miscellaneous",
	                          "Newspaper Article",
	                          "Patent",
	                          "Report",
	                          "Software");


	// The default list of fields that will be searched by the "main fields" search option:
	// Specify a comma-separated list of fields from MySQL table 'refs'. The given fields
	// will be searched via an OR search if the user performs a search with "main fields"
	// selected from a search field drop-down menu; these fields will also be included as
	// separate entries in the "Quick Search" drop-down menu.
	$defaultMainFields = "author, title, publication, keywords, abstract"; // e.g. "author, title, publication, keywords, abstract"


	// The list of fields that are available in the "main fields" selector of the user's
	// account options page:
	// The given field names must match column names in MySQL tables 'refs' and 'user_data'.
	// The given fields will be available to the user to add them to his/her preferred list
	// of "main fields". The fields selected by the user will be used instead of the default
	// list of "main fields" provided in '$defaultMainFields' (see above). The user's
	// default list of "main fields" can be specified in '$defaultUserOptions["main_fields"]'
	// (see below).
	$availableMainFields = array("author", "title", "year", "publication", "abbrev_journal",
	                             "editor", "series_title", "abbrev_series_title", "keywords",
	                             "abstract", "area", "notes", "call_number", "serial",
	                             "user_keys", "user_notes", "user_groups", "cite_key");


	// The list of fields that will be displayed by default in List view (i.e. the default
	// columnar output style):
	// (specify a comma-separated list of fields from MySQL table 'refs')
	// 
	// - These "major" fields will be always included by default:
	$defaultFieldsListViewMajor = "author, title, year, publication"; // e.g. "author, title, year, publication"

	// - These "minor" fields will only be included by default if there are no other fields
	//   that are to be included:
	//   (e.g., if one uses "Quick Search" to search the 'abstract' or 'keywords' fields,
	//    those fields will be displayed instead of the "minor" fields listed here)
	$defaultFieldsListViewMinor = "volume, pages"; // e.g. "volume, pages"


	// The default list of fields that will be available in drop-down menus of the
	// results header:
	// (given field names must match column names in MySQL tables 'refs' and 'user_data';
	//  you can change the order of fields to control the field order in the drop-down menus)
	// 
	// - These fields will be visible for all users, no matter whether they are logged in or not:
	$defaultDropDownFieldsEveryone = array("author", "title", "year", "keywords", "abstract",
	                                       "type", "publication", "abbrev_journal", "volume",
	                                       "issue", "pages", "thesis", "publisher", "place",
	                                       "editor", "series_title", "language", "area",
	                                       "notes", "call_number", "serial");

	// - These fields will be only visible to logged in users:
	$defaultDropDownFieldsLogin = array("location", "marked", "copy", "selected", "user_keys",
	                                    "user_notes", "user_file", "user_groups", "cite_key");


	// Defines the default user options when adding new users:
	$defaultUserOptions = array(
	                            // controls whether to include cite keys on export or not:
	                            "export_cite_keys"                => "yes", // possible values: "yes", "no"

	                            // controls whether cite keys will be auto-generated on export:
	                            "autogenerate_cite_keys"          => "yes", // possible values: "yes", "no"

	                            // controls whether auto-generated cite keys will overwrite record-specific contents from
	                            // the user-specific 'cite_key' field on export:
	                            "prefer_autogenerated_cite_keys"  => "no", // possible values: "yes", "no"

	                            // controls whether the user's custom cite key format shall be used (instead of the default
	                            // cite key format provided in '$defaultCiteKeyFormat', see below):
	                            "use_custom_cite_key_format"      => "no", // possible values: "yes", "no"

	                            // the user's custom cite key format:
	                            // see comments for '$fileNamingScheme' (below) for more info on supported placeholders
	                            "cite_key_format"                 => "<:firstAuthor:><:year:>", // e.g. "<:firstAuthor:><:year:>"

	                            // controls whether to add incrementing numbers to any duplicate cite keys:
	                            "uniquify_duplicate_cite_keys"    => "yes", // possible values: "yes", "no"

	                            // controls how non-ASCII characters will be treated in cite keys:
	                            // (keep empty in order to use the site default given in '$handleNonASCIICharsInCiteKeysDefault')
	                            "nonascii_chars_in_cite_keys"     => "", // possible values: "strip", "keep", "transliterate", ""

	                            // controls whether the user's custom text citation format shall be used (instead of the default
	                            // text citation format provided in '$defaultTextCitationFormat', see below):
	                            "use_custom_text_citation_format" => "no", // possible values: "yes", "no"

	                            // the user's custom text citation format:
	                            // see comments for '$fileNamingScheme' (below) for more info on supported placeholders
	                            "text_citation_format"            => "<:authors[2| & | et al.]:>< :year:>< {:recordIdentifier:}>", // e.g. "<:authors[2| & | et al.]:>< :year:>< {:recordIdentifier:}>"

	                            // the user's preferred number of records that's returned by default:
	                            "records_per_page"                => "10", // e.g. "5"

	                            // the user's preference for displaying auto-completions:
	                            "show_auto_completions"           => "yes", // possible values: "yes", "no"

	                            // the user's preferred list of "main fields" (that will be used instead of the
	                            // default list of "main fields" provided in '$defaultMainFields', see above):
	                            "main_fields"                     => "author, title, publication, keywords, abstract"); // e.g. "author, title, publication, keywords, abstract"


	// The default cite key format used for auto-generation of cite keys:
	// see comments for '$fileNamingScheme' (below) for more info on supported placeholders
	$defaultCiteKeyFormat = "<:authors:><:year:>"; // e.g. "<:authors:><:year:>"


	// Default setting that controls how non-ASCII characters will be treated in auto-generated cite keys:
	//   - "strip": removes any non-ASCII characters
	//   - "keep": keeps any non-ASCII characters (note that bibutils may strip any non-ASCII chars from cite
	//             keys when exporting to Endnote, RIS or BibTeX, depending on the bibutils version you're using)
	//   - "transliterate": attempts to transliterate most of the non-ASCII characters and strips all non-ASCII
	//                      chars that can't be converted into ASCII equivalents (this is the recommended option)
	$handleNonASCIICharsInCiteKeysDefault = "transliterate"; // possible values: "strip", "keep", "transliterate"


	// The name of the default citation style:
	// This name must correspond to an entry within the 'styles' MySQL table.
	// It will be used for citation output within 'show.php', 'opensearch.php' and the 'generateRSS()' function.
	$defaultCiteStyle = "APA";


	// The size of the PDF page (used when outputting citations as PDF):
	$pdfPageSize = "a4"; // possible values: "a4", "letter"


	// The default text citation format:
	// see comments for '$fileNamingScheme' (below) for more info on supported placeholders
	$defaultTextCitationFormat = "<:authors[2| & | et al.]:>< :year:>< {:recordIdentifier:}>"; // e.g. "<:authors[2| & | et al.]:>< :year:>< {:recordIdentifier:}>"


	// The name of the default export format:
	// This name must correspond to an entry within the 'formats' MySQL table (of 'format_type' = "export").
	// It will be used when 'show.php' was called with 'submit=Export' but no 'exportFormat' parameter was specified.
	$defaultExportFormat = "RIS";


	// Specify whether export of data should be allowed via the refbase GUI for anyone who isn't logged in:
	// Note that this setting overrides the permission settings 'allow_export' and 'allow_batch_export' for
	// anonymous users ('userID=0') w.r.t. the *web* interface. E.g., with '$allowAnonymousGUIExport' set to
	// "no" and export permissions for 'userID=0' set to "yes", you can allow anonymous access to refbase
	// via its export APIs while disallowing export by anonymous users via the web interface.
	$allowAnonymousGUIExport = "yes"; // possible values: "yes", "no"


	// The name of the default feed format:
	// This specifies whether RSS XML or Atom XML will be offered as default feed format
	// (e.g. in auto-discovery links of the HTML head).
	$defaultFeedFormat = "RSS XML"; // possible values: "RSS XML", "Atom XML"


	// Specify who'll be allowed to see files associated with any records:
	// Set this variable to "everyone" if you want _any_ visitor of your database (whether he's logged
	// in or not) to be able to see links to any associated files. If you choose "login" instead, a
	// user must be logged in to view any files. Finally, use "user-specific" if you want to set this
	// permission individually for each user. Note that, setting this variable to either "everyone" or
	// "login" will override the user-specific permission setting for file downloads ("allow_download"
	// permission).
	$fileVisibility = "user-specific"; // possible values: "everyone", "login", "user-specific"


	// Specify a condition where files will be always made visible [optional]:
	// This variable can be used to specify a condition where the above rule of file visibility can be
	// by-passed (thus allowing download access to some particular files while all other files are
	// protected by the above rule). Files will be shown regardless of the above rule if the specified
	// condition is met. First param must be a valid field name from table 'refs', second param the
	// conditional expression (specified as /perl-style regular expression/ -> see note at the end of
	// this file). The given example will *always* show links to files where the 'thesis' field of the
	// corresponding record is not empty. If you do not wish to make any exception to the above rule,
	// just specify an empty array, like: '$fileVisibilityException = array();'. Use the "/.../i"
	// modifier to invoke case insensitive matching.
	$fileVisibilityException = array("thesis", "/.+/"); // e.g. 'array("thesis", "/.+/")'


	// Define what will be searched by "library_search.php":
	// refbase offers a "Library Search" feature that provides a separate search page for searching an
	// institution's library. All searches performed thru this search form will be restricted to
	// records that match the specified condition. First param must be a valid field name from table
	// 'refs', second param the conditional expression (specified as MySQL extended regular expression
	// -> see note at the end of this file). Of course, you could also use this feature to restrict
	// searches thru "library_search.php" by _any_ other condition. E.g., with "location" as the first
	// parameter and your own login email address as the second parameter, any "library" search would
	// be restricted to your personal literature data set. If you don't want to make any use of
	// "library_search.php", specify an empty array, like: '$librarySearchPattern = array();'
	$librarySearchPattern = array("location", "library"); // e.g. 'array("location", "IP Library")'


	// Define the directory path that's used to save session data and to write any temporary files.
	// Usually, you can leave this variable as is. However, if you're on a hosted service, your
	// Internet Service Provider may have given you a specific session/temp DIR path which you may need
	// to specify here.
	$sessionTempDir = session_save_path(); // e.g. session_save_path(), or "/var/www/web12345/phptmp"


	// The base DIR path to your default file directory:
	// I.e., the local path to the root directory where any PDF files etc. are stored. This must be a
	// valid path specification to a local directory that's accessible (read+write) by the server. As an
	// example, if you're using the Apache web server on a unix machine and if your default file
	// directory (named "files") is located on the root level of your refbase script directory (named
	// "refs") the path spec could be something like: "/usr/local/httpd/htdocs/refs/files/"
	$filesBaseDir = "PATH_TO_FILES_BASE_DIRECTORY"; // e.g. "/usr/local/httpd/htdocs/refs/files/"


	// The URL to the default file directory that you've specified in $filesBaseDir:
	// Any string within the 'file' field of the 'refs' table that doesn't start with "http://" or
	// "ftp://" will get prefixed with this URL. If your files directory is within your refbase root
	// directory, specify a *relative* path (e.g.: "files/" if the directory is on the same level as the
	// refbase php scripts and it's named "files"). Alternatively, if your files directory is somewhere
	// else within your server's DocumentRoot, you must specify an *absolute* path (e.g.: "/files/" if
	// the directory is on the uppermost level of your DocumentRoot and it's named "files"). If,
	// instead, you want to use *complete* path specifications within the 'file' field (e.g. because
	// your files are located within multiple directories), simply don't specify any URL here, i.e.,
	// keep it empty: '$filesBaseURL = "";'
	$filesBaseURL = "URL_TO_FILES_BASE_DIRECTORY"; // e.g. "files/"


	// Specify if files should be moved into sub-directories:
	//   - "never": files will always be copied to the root files dir (i.e. don't use any sub-directories)
	//   - "always": auto-generate new sub-directories if required (according to the naming scheme
	//               given in '$dirNamingScheme', see below)
	//   - "existing": only copy files into sub-directories if the sub-directory already exists
	$moveFilesIntoSubDirectories = "always"; // possible values: "never", "always", "existing"


	// Specify the naming scheme for auto-generated sub-directories:
	// (see comments for '$fileNamingScheme' for more info on supported placeholders)
	// Notes: - use slashes ('/' or '\') to separate between multiple sub-directories
	//        - you're allowed to use any characters between (or within) placeholders except the delimiters
	//          '<', '>' and ':'
	//        - handling of any non-ASCII chars will be controlled by '$handleNonASCIIChars' and unwanted
	//          characters can be excluded with the help of '$allowedDirNameCharacters' (see below)
	$dirNamingScheme = "<:firstAuthor:>/<:year:>"; // e.g. "<:firstAuthor:>/<:year:>"


	// Specify whether refbase shall rename uploaded files:
	// (note that if '$renameUploadedFiles' is set to "no", uploaded files will be blocked if they
	// contain any other characters than specified in '$allowedFileNameCharacters', see below)
	$renameUploadedFiles = "yes"; // possible values: "yes", "no"


	// Specify how to rename uploaded files:
	// Supported placeholders:
	// <:serial:>, <:authors:>, <:firstAuthor:>, <:secondAuthor:>, <:title:>, <:year:>, <:publication:>,
	// <:abbrevJournal:>, <:volume:>, <:issue:>, <:pages:>, <:startPage:>, <:endPage:>, <:keywords:>,
	// <:issn:>, <:isbn:>, <:issn_isbn:>, <:area:>, <:notes:>, <:userKeys:>, <:citeKey:>, <:doi:>,
	// <:recordIdentifier:>, <:randomNumber:>
	// Notes: - some of these placeholders offer options (e.g. how many words/items shall be extracted
	//          from the given field), please see the refbase online documentation for more info about
	//          placeholders and their syntax: <http://placeholders.refbase.net/>
	//        - existing file extensions will be kept untouched by this naming scheme
	//        - you're allowed to use any characters between (or within) placeholders except the delimiters
	//          '<', '>' and ':'
	//        - handling of any non-ASCII chars will be controlled by '$handleNonASCIIChars' and unwanted
	//          characters can be excluded with the help of '$allowedFileNameCharacters' (see below)
	//        - it is strongly recommended to always include the '<:serial:>' placeholder in order to ensure
	//          truly unique file names, otherwise you'll risk files already on the server getting overwritten
	//          by newly uploaded files (that got assigned the same name)
	$fileNamingScheme = "<:serial:>_<:authors:><:year:>"; // e.g. "<:serial:>_<:authors:><:year:>"


	// Specify how non-ASCII characters shall be treated in file/directory names:
	//   - "strip": removes any non-ASCII characters
	//   - "keep": keeps any non-ASCII characters (which, depending on your file system, may cause problems!)
	//   - "transliterate": attempts to transliterate most of the non-ASCII characters and strips all non-ASCII
	//                      chars that can't be converted into ASCII equivalents (this is the recommended option)
	$handleNonASCIIChars = "transliterate"; // possible values: "strip", "keep", "transliterate"


	// Specify all characters that will be allowed in file names:
	// In addition to the character conversion invoked by '$handleNonASCIIChars' (see above), this variable
	// allows you to further restrict generation of file names to a particular set of characters.
	// If '$renameUploadedFiles' is set to "no", uploaded files will be blocked if they contain any other
	// characters than specified here. If '$renameUploadedFiles' is set to "yes", any characters which
	// are not listed below will be removed from the generated file name.
	// (given expression must be specified as contents of a perl-style regular expression character class -> see
	// note at the end of this file; you can simply specify an empty string if you don't want any further character
	// conversion: '$allowedFileNameCharacters = "";')
	$allowedFileNameCharacters = "a-zA-Z0-9+_.-"; // e.g. "a-zA-Z0-9+_.-"

	// Specify all characters that will be allowed in directory names:
	// (same notes apply as for '$allowedFileNameCharacters')
	$allowedDirNameCharacters = "a-zA-Z0-9+_-"; // e.g. "a-zA-Z0-9+_-"


	// Choose whether case transformations shall be applied to the file/directory names:
	//   - "no": don't perform any case tranformations (i.e, keep the file/directory names as is)
	//   - "lower": transform all characters to lower case
	//   - "upper": transform all characters to upper case
	// (note that case transformations will be always performed regardless of any other file/directory
	// related settings)
	// File names:
	$changeCaseInFileNames = "no"; // possible values: "no", "lower", "upper"

	// DIR names:
	$changeCaseInDirNames = "lower"; // possible values: "no", "lower", "upper"


	// Default options for placeholders used by the file/directory name, cite key and
	// link auto-generation features:
	// Notes: - please see the refbase online documentation for more info about placeholders and
	//          their syntax: <http://placeholders.refbase.net/>
	//
	// Default options for '<:authors:>':
	// syntax: "[USE_MAX_NUMBER_OF_AUTHORS|AUTHOR_CONNECTOR|ET_AL_IDENTIFIER]"
	$extractDetailsAuthorsDefault = "[2|+|_etal]"; // e.g. "[2|+|_etal]"

	// Default options for '<:title:>':
	// syntax: "[NUMBER_OF_WORDS_FROM_TITLE_FIELD]"
	$extractDetailsTitleDefault = "[1]"; // e.g. "[1]"

	// Default options for '<:year:>':
	// syntax: "[DIGIT_FORMAT]"
	$extractDetailsYearDefault = "[4]"; // possible values: "[2]", "[4]"

	// Default options for '<:publication:>':
	// syntax: "[NUMBER_OF_WORDS_FROM_PUBLICATION_FIELD]"
	$extractDetailsPublicationDefault = "[3]"; // e.g. "[3]"

	// Default options for '<:abbrevJournal:>':
	// syntax: "[NUMBER_OF_WORDS_FROM_ABBREVJOURNAL_FIELD]"
	$extractDetailsAbbrevJournalDefault = "[3]"; // e.g. "[3]"

	// Default options for '<:keywords:>':
	// syntax: "[NUMBER_OF_ITEMS_FROM_KEYWORDS_FIELD]"
	$extractDetailsKeywordsDefault = "[1]"; // e.g. "[1]"

	// Default options for '<:area:>':
	// syntax: "[NUMBER_OF_ITEMS_FROM_AREA_FIELD]"
	$extractDetailsAreaDefault = "[1]"; // e.g. "[1]"

	// Default options for '<:notes:>':
	// syntax: "[NUMBER_OF_WORDS_FROM_NOTES_FIELD]"
	$extractDetailsNotesDefault = "[1]"; // e.g. "[1]"

	// Default options for '<:userKeys:>':
	// syntax: "[NUMBER_OF_ITEMS_FROM_USERKEYS_FIELD]"
	$extractDetailsUserKeysDefault = "[1]"; // e.g. "[1]"

	// Default options for '<:randomNumber:>':
	// syntax: "[MINIMUM_NUMBER|MAXIMUM_NUMBER]"
	// specify an empty string (or "[|]") to use the maximum possible range: '$extractDetailsRandomNumberDefault = "";'
	$extractDetailsRandomNumberDefault = "[0|99999]"; // e.g. "[0|99999]"

	
	// The default view that is displayed for found results:
	//   - "List" will produce the columnar output style (List view)
	//   - "Cite" returns found records as citations (Citation view)
	//   - "Display" displays full record details (Details view)
	//   - "Browse" displays unique field values (Browse view)
	$defaultView = "List"; // possible values: "List", "Cite", "Display", "Browse"


	// Specify whether additional info is made available in Citation view by clicking a triangle
	// widget underneath each citation, and which fields shall be included:
	// (given field names must match column names in MySQL tables 'refs' and 'user_data';
	//  you can change the order of fields to control the display order; to completely disable
	//  this feature, specify an empty array, like: '$additionalFieldsCitationView = array();')
	$additionalFieldsCitationView = array("abstract", "keywords", "area", "user_keys",
	                                      "user_groups", "user_notes", "cite_key");


	// Specify whether additional fields shall be displayed in Details view by default:
	// In Details view, these "additional fields" will get displayed between the 'abstract'
	// and 'call_number' fields; they constitute fields that are usually less important
	// (such as publisher or series info)
	$showAdditionalFieldsDetailsViewDefault = "yes"; // possible values: "yes", "no"


	// Specify whether user-specific fields shall be displayed in Details view by default:
	// In Details view, user-specific (i.e. personal/private) fields will get displayed for
	// logged-in users below all other fields with a light yellow background; they constitute
	// fields that are individual for each user and cannot be viewed by other users
	$showUserSpecificFieldsDetailsViewDefault = "yes"; // possible values: "yes", "no"


	// Specify whether the results header & footer should be displayed open or closed by default,
	// or whether they should be entirely hidden from the interface:
	// (display defaults are specified for each of the supported view types individually;
	//  see comments for '$defaultView' for more info on the different view types)
	// Possible view types:     "List", "Cite", "Display", "Browse"
	// Possible display values: "open", "closed", "hidden"
	// 
	// - Results header:
	//                                   "view type" => "display value"
	$displayResultsHeaderDefault = array("List"      => "closed",
	                                     "Cite"      => "closed",
	                                     "Display"   => "closed",
	                                     "Browse"    => "open");

	// - Results footer:
	//   (note that the cite, group & export functionality doesn't yet work in Browse view)
	//                                   "view type" => "display value"
	$displayResultsFooterDefault = array("List"      => "open",
	                                     "Cite"      => "closed",
	                                     "Display"   => "open",
	                                     "Browse"    => "hidden");


	// Specify which links shall be displayed (if available and if the Links column is visible):
	// (note that for List and Citation view, only one link will be printed for links of type
	// url/doi/isbn/xref; order of preference: doi, url, isbn, xref)
	// Possible array items: "details", "edit", "file", "url", "doi", "isbn", "xref"
	// 
	// - List view:
	$showLinkTypesInListView = array("details", "edit", "file", "url", "doi", "isbn", "xref");

	// - Citation view:
	$showLinkTypesInCitationView = array("details", "edit", "file", "url", "doi", "isbn", "xref");


	// Specify the views where clickable search links shall be created for items in certain fields:
	// (note that for Citation view, search links are currently only provided within the "more info"
	//  section underneath each citation, see also variable '$additionalFieldsCitationView'; to
	//  completely disable this feature for all views, specify an empty array like:
	//  '$showFieldItemLinks = array();')
	$showFieldItemLinks = array("List", "Cite", "Display"); // possible array items: "List", "Cite", "Display"
	
	
	// Specify the list of fields whose items should be made into clickable search links:
	// (note that this feature isn't available for all fields from MySQL tables 'refs' and
	//  'user_data', nor does it make sense for all fields)
	// Possible fields: "author", "title", "type", "year", "publication", "abbrev_journal",
	//                  "keywords", "thesis", "area", "expedition", "notes", "serial", "marked",
	//                  "selected", "user_keys", "user_notes", "user_groups", "cite_key"
	$linkedFields = array("author", "year", "publication", "abbrev_journal", "keywords", "area",
	                      "user_keys", "user_notes", "user_groups");


	// Specify the maximum number of links to found results pages that are displayed per page:
	$maximumBrowseLinks = "10";


	// Define 'accesskey' values which allow for keyboard navigation of the refbase interface:
	// An access key is a single character; for maximum compatibility, use only the lowercase
	// ASCII letters "a" through "z". Alternatively, you might want to use digits for access
	// keys in order to avoid conflicts with built-in keyboard shortcuts in browsers and other
	// software. To disable a particular accesskey, specify an empty value (""); to completely
	// disable all access keys, specify an empty array, like: '$accessKeys = array();'
	$accessKeys = array(
	                    // page header:
	                    "home"        => "0", // "Home" link (e.g. "0")
	                    "show_all"    => "1", // "Show All" link (e.g. "1")
	                    "search"      => "", // "Simple Search" link (e.g. "s")
	                    "adv_search"  => "",  // "Advanced Search" link
	                    "add"         => "", // "Add Record" link (e.g. "a")
	                    "import"      => "", // "Import" link (e.g. "i")
	                    "sql_query"   => "", // "your query" link (e.g. "q")
	                    "save_query"  => "", // "save" link (e.g. "v")
	                    "dups"        => "", // "dups" link (e.g. "u")
	                    "history"     => "", // "history" link (e.g. "y")
	                    "my_refs"     => "7", // "My Refs" link (e.g. "7")
	                    "my_opt"      => "8", // "Options" link (e.g. "8")
	                    "login"       => "9", // "Login/Logout" link (e.g. "9")
	                    "qck_search"  => "f", // text entry field of the "Quick Search" form (e.g. "f")
	                    // results header:
	                    "header"      => ",", // "Search & Display Options" link that toggles visibility of the results header (e.g. ",")
	                    "refine"      => "",  // text entry field of the "Search within Results" form
	                    "max_rows"    => "r", // "records per page" text entry field of the "Display Options" form (e.g. "r")
	                    // browse links:
	                    "next"        => "2", // "next results page" link (e.g. "2" or "n")
	                    "previous"    => "", // "previous results page" link (e.g. "p")
	                    "list"        => "3", // "List View" link (e.g. "3")
	                    "cite"        => "4", // "Citations" link (e.g. "4")
	                    "details"     => "5", // "Details" link (e.g. "5")
	                    "print"       => "6", // "Web/Print View" link (e.g. "6")
	                    // results footer:
	                    "footer"      => ".", // "Cite, Group & Export Options" link that toggles visibility of the results footer (e.g. ".")
	                    "biblio"      => "", // "Cite" button of the "Save Citations" form (e.g. "c")
	                    "export"      => "", // "Export" button of the "Export Records" form (e.g. "e")
	                    // page footer:
	                    "sql_search"  => "",  // "SQL Search" link
	                    "cql_search"  => "",  // "CQL Search" link
	                    "lib_search"  => "",  // "Library Search" link
	                    "show_rec"    => "", // "Show Record" link (e.g. "w")
	                    "extract"     => "", // "Extract Citations" link (e.g. "x")
	                    // search pages:
	                    "search_opt"  => ",", // "Search/Display Options" link that toggles visibility of the search/display options (e.g. ",")
	                    "search_help" => ".", // "Help/Examples" link that toggles visibility of the inline help/examples (e.g. ".")
	                   );


	// Specify the base URL to an OpenURL resolver:
	// Notes: - more info about the OpenURL standard (including pointers to further documentation)
	//          is available at <http://en.wikipedia.org/wiki/OpenURL>
	//        - specify an empty string if you don't want any auto-generation of OpenURL links:
	//          '$openURLResolver = "";'
	$openURLResolver = "http://www.crossref.org/openurl";
	// Examples for OpenURL resolvers:
	// - Generic OpenURL resolver provided by CrossRef: "http://www.crossref.org/openurl"
	//   (note that the CrossRef.org resolver requires you to register for a free account,
	//    see the comments for '$crossRefReqDat' below)
	// 
	// - 1Cate, the OpenURL link-server from ISI/Openly: "http://isi.1cate.com/?sid=ISI:WoS"
	// 
	// - WorldCat OpenURL resolver which redirects to "the best" resolver for the client IP address:
	//   "http://worldcatlibraries.org/registry/gateway"

	// Specify your CrossRef account credentials:
	// Notes: - the CrossRef.org OpenURL resolver requires users to have an account and to supply their login
	//          credentials in the 'pid' parameter of the OpenURL request; for more info please see:
	//          <http://www.crossref.org/openurl>
	//        - to request a (free) account, complete the form at: <http://www.crossref.org/requestaccount/>
	//        - after you've created & verified your account, enter your login credentials (e.g.
	//          "name@someplace.com" or "username:password") here
	$crossRefReqDat = "info@refbase.net"; // e.g. "info@refbase.net"


	// Define the format for an ISBN lookup URL:
	// Notes: - obviously, the ISBN link will only get auto-generated if an ISBN number is present
	//        - specify an empty string if you don't want any auto-generation of ISBN links: '$isbnURLFormat = "";'
	$isbnURLFormat = "http://isbn.nu/<:isbn:>";
	// e.g. isbn.nu ISBN resolver: "http://isbn.nu/<:isbn:>"


	// If your institution has access to particular databases of the "Cambridge Scientific Abstracts"
	// (CSA) Internet Database Service (http://www.csa1.co.uk/csa/index.html), you can specify the
	// direct URL to the database(s) below. Why that? The 'import.php' script offers an import form
	// that enables a user to import records from the CSA Internet Database Service. The URL you specify
	// here will appear as link within the explanatory text of 'import.php' pointing your users
	// directly to the CSA databases you have access to.
	// e.g. "http://www.csa1.co.uk/htbin/dbrng.cgi?username=...&amp;access=...&amp;cat=aquatic&amp;quick=1"
	$importCSArecordsURL = "http://www.csa1.co.uk/csa/index.html";


	// The search & replace actions defined in file 'includes/transtab_refbase_html.inc.php' will be
	// applied to the 'title', 'address', 'keywords' and 'abstract' fields (the list of fields can be
	// modified below, see '$searchReplaceActionsArray'). This feature is meant to provide richer text
	// capabilities (like displaying italics or super-/subscript) from the plain text data delivered by
	// the MySQL database. It works by means of "human readable markup" that's used within the plain
	// text fields of the database to define rich text characters. E.g., if you enclose a particular
	// word by substrings (like '_in-situ_') this word will be output in italics. Similarly, '**word**'
	// will print the word in boldface, 'CO[sub:2]' will cause the number in 'CO2' to be set as
	// subscript while '[delta]' will produce a greek delta letter. Feel free to customize this markup
	// scheme to your needs (the left column of the array in 'transtab_refbase_html.inc.php' represents
	// regular expression patterns matching the human readable markup that's used in your database while
	// the right column represents the equivalent HTML encoding). If you do not wish to perform any
	// search and replace actions, just specify an empty array, like: '$transtab_refbase_html =
	// array();'.
	include 'includes/transtab_refbase_html.inc.php'; // include refbase markup -> HTML search & replace patterns


	// Defines search & replace 'actions' that will be applied to all those refbase fields that are listed in the corresponding 'fields' element
	// upon WEB DISPLAY. Search & replace patterns must be specified as perl-style regular expression (including the leading & trailing slashes)
	// and may include mode modifiers (such as '/.../i' to perform a case insensitive match) -> see note at the end of this file.
	// If you don't want to perform any search and replace actions, specify an empty array, like: '$searchReplaceActionsArray = array();')
	//                                                    "/Search Pattern/"  =>  "Replace Pattern"
	$searchReplaceActionsArray = array(
	                                   array(
	                                         'fields'  => array("title", "publication", "abbrev_journal", "address", "keywords", "abstract", "orig_title", "series_title", "abbrev_series_title", "notes"),
	                                         'actions' => $transtab_refbase_html // perform search & replace actions that provide for human readable markup (as defined in 'includes/transtab_refbase_html.inc.php')
	                                        )
//	                                   ,
//	                                   array(
//	                                         'fields'  => array("address", "abstract"),
//	                                         'actions' => array(
//	                                                            "/((?:ht|f)tp:\/\/[^ \"<>\r\n]+?)(?=&gt;|&quot;|[ \"<>\r\n]|$)/" => "<a target='_new' href='\\1'>\\1</a>", // generate clickable links from any web addresses
//	                                                            "/([0-9a-zA-Z._-]+)@([0-9a-zA-Z._-]+)\\.([a-zA-Z]{2,3})/"        => "<a href='mailto:\\1@\\2.\\3'>\\1@\\2.\\3</a>" // generate clickable links from any email addresses
//	                                                           )
//	                                        )
	                                   );

	// --------------------------------------------------------------------

	// Note regarding the use of regular expressions:

	// Certain variables within this file expect you to enter search patterns as either "MySQL
	// extended" or "perl-style" regular expression. While regular expressions provide a powerful
	// syntax for searching they may be somewhat difficult to write and daunting if you're new to the
	// concept. If you require help coming up with a correct regular expression that matches your
	// needs, you may want to visit <http://grep.extracts.de/> for pointers to language-specific
	// documentation, tutorials, books and regex-aware applications. Alternatively, you're welcome to
	// post a message to the refbase help forum: <http://sourceforge.net/forum/forum.php?forum_id=218758>

	$ignoreAdminWarning = false;
?>
