// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the S3 Inventory configuration for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <i>Amazon S3 API Reference</i>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct InventoryConfiguration {
    /// <p>Contains information about where to publish the inventory results.</p>
    pub destination: ::std::option::Option<crate::types::InventoryDestination>,
    /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
    pub is_enabled: bool,
    /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
    pub filter: ::std::option::Option<crate::types::InventoryFilter>,
    /// <p>The ID used to identify the inventory configuration.</p>
    pub id: ::std::string::String,
    /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
    pub included_object_versions: crate::types::InventoryIncludedObjectVersions,
    /// <p>Contains the optional fields that are included in the inventory results.</p>
    pub optional_fields: ::std::option::Option<::std::vec::Vec<crate::types::InventoryOptionalField>>,
    /// <p>Specifies the schedule for generating inventory results.</p>
    pub schedule: ::std::option::Option<crate::types::InventorySchedule>,
}
impl InventoryConfiguration {
    /// <p>Contains information about where to publish the inventory results.</p>
    pub fn destination(&self) -> ::std::option::Option<&crate::types::InventoryDestination> {
        self.destination.as_ref()
    }
    /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
    pub fn is_enabled(&self) -> bool {
        self.is_enabled
    }
    /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
    pub fn filter(&self) -> ::std::option::Option<&crate::types::InventoryFilter> {
        self.filter.as_ref()
    }
    /// <p>The ID used to identify the inventory configuration.</p>
    pub fn id(&self) -> &str {
        use std::ops::Deref;
        self.id.deref()
    }
    /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
    pub fn included_object_versions(&self) -> &crate::types::InventoryIncludedObjectVersions {
        &self.included_object_versions
    }
    /// <p>Contains the optional fields that are included in the inventory results.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.optional_fields.is_none()`.
    pub fn optional_fields(&self) -> &[crate::types::InventoryOptionalField] {
        self.optional_fields.as_deref().unwrap_or_default()
    }
    /// <p>Specifies the schedule for generating inventory results.</p>
    pub fn schedule(&self) -> ::std::option::Option<&crate::types::InventorySchedule> {
        self.schedule.as_ref()
    }
}
impl InventoryConfiguration {
    /// Creates a new builder-style object to manufacture [`InventoryConfiguration`](crate::types::InventoryConfiguration).
    pub fn builder() -> crate::types::builders::InventoryConfigurationBuilder {
        crate::types::builders::InventoryConfigurationBuilder::default()
    }
}

/// A builder for [`InventoryConfiguration`](crate::types::InventoryConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct InventoryConfigurationBuilder {
    pub(crate) destination: ::std::option::Option<crate::types::InventoryDestination>,
    pub(crate) is_enabled: ::std::option::Option<bool>,
    pub(crate) filter: ::std::option::Option<crate::types::InventoryFilter>,
    pub(crate) id: ::std::option::Option<::std::string::String>,
    pub(crate) included_object_versions: ::std::option::Option<crate::types::InventoryIncludedObjectVersions>,
    pub(crate) optional_fields: ::std::option::Option<::std::vec::Vec<crate::types::InventoryOptionalField>>,
    pub(crate) schedule: ::std::option::Option<crate::types::InventorySchedule>,
}
impl InventoryConfigurationBuilder {
    /// <p>Contains information about where to publish the inventory results.</p>
    /// This field is required.
    pub fn destination(mut self, input: crate::types::InventoryDestination) -> Self {
        self.destination = ::std::option::Option::Some(input);
        self
    }
    /// <p>Contains information about where to publish the inventory results.</p>
    pub fn set_destination(mut self, input: ::std::option::Option<crate::types::InventoryDestination>) -> Self {
        self.destination = input;
        self
    }
    /// <p>Contains information about where to publish the inventory results.</p>
    pub fn get_destination(&self) -> &::std::option::Option<crate::types::InventoryDestination> {
        &self.destination
    }
    /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
    /// This field is required.
    pub fn is_enabled(mut self, input: bool) -> Self {
        self.is_enabled = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
    pub fn set_is_enabled(mut self, input: ::std::option::Option<bool>) -> Self {
        self.is_enabled = input;
        self
    }
    /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
    pub fn get_is_enabled(&self) -> &::std::option::Option<bool> {
        &self.is_enabled
    }
    /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
    pub fn filter(mut self, input: crate::types::InventoryFilter) -> Self {
        self.filter = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
    pub fn set_filter(mut self, input: ::std::option::Option<crate::types::InventoryFilter>) -> Self {
        self.filter = input;
        self
    }
    /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
    pub fn get_filter(&self) -> &::std::option::Option<crate::types::InventoryFilter> {
        &self.filter
    }
    /// <p>The ID used to identify the inventory configuration.</p>
    /// This field is required.
    pub fn id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID used to identify the inventory configuration.</p>
    pub fn set_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.id = input;
        self
    }
    /// <p>The ID used to identify the inventory configuration.</p>
    pub fn get_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.id
    }
    /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
    /// This field is required.
    pub fn included_object_versions(mut self, input: crate::types::InventoryIncludedObjectVersions) -> Self {
        self.included_object_versions = ::std::option::Option::Some(input);
        self
    }
    /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
    pub fn set_included_object_versions(mut self, input: ::std::option::Option<crate::types::InventoryIncludedObjectVersions>) -> Self {
        self.included_object_versions = input;
        self
    }
    /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
    pub fn get_included_object_versions(&self) -> &::std::option::Option<crate::types::InventoryIncludedObjectVersions> {
        &self.included_object_versions
    }
    /// Appends an item to `optional_fields`.
    ///
    /// To override the contents of this collection use [`set_optional_fields`](Self::set_optional_fields).
    ///
    /// <p>Contains the optional fields that are included in the inventory results.</p>
    pub fn optional_fields(mut self, input: crate::types::InventoryOptionalField) -> Self {
        let mut v = self.optional_fields.unwrap_or_default();
        v.push(input);
        self.optional_fields = ::std::option::Option::Some(v);
        self
    }
    /// <p>Contains the optional fields that are included in the inventory results.</p>
    pub fn set_optional_fields(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::InventoryOptionalField>>) -> Self {
        self.optional_fields = input;
        self
    }
    /// <p>Contains the optional fields that are included in the inventory results.</p>
    pub fn get_optional_fields(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::InventoryOptionalField>> {
        &self.optional_fields
    }
    /// <p>Specifies the schedule for generating inventory results.</p>
    /// This field is required.
    pub fn schedule(mut self, input: crate::types::InventorySchedule) -> Self {
        self.schedule = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the schedule for generating inventory results.</p>
    pub fn set_schedule(mut self, input: ::std::option::Option<crate::types::InventorySchedule>) -> Self {
        self.schedule = input;
        self
    }
    /// <p>Specifies the schedule for generating inventory results.</p>
    pub fn get_schedule(&self) -> &::std::option::Option<crate::types::InventorySchedule> {
        &self.schedule
    }
    /// Consumes the builder and constructs a [`InventoryConfiguration`](crate::types::InventoryConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`is_enabled`](crate::types::builders::InventoryConfigurationBuilder::is_enabled)
    /// - [`id`](crate::types::builders::InventoryConfigurationBuilder::id)
    /// - [`included_object_versions`](crate::types::builders::InventoryConfigurationBuilder::included_object_versions)
    pub fn build(self) -> ::std::result::Result<crate::types::InventoryConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::InventoryConfiguration {
            destination: self.destination,
            is_enabled: self.is_enabled.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "is_enabled",
                    "is_enabled was not specified but it is required when building InventoryConfiguration",
                )
            })?,
            filter: self.filter,
            id: self.id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "id",
                    "id was not specified but it is required when building InventoryConfiguration",
                )
            })?,
            included_object_versions: self.included_object_versions.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "included_object_versions",
                    "included_object_versions was not specified but it is required when building InventoryConfiguration",
                )
            })?,
            optional_fields: self.optional_fields,
            schedule: self.schedule,
        })
    }
}
