/*
 *   mwmwin.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <signal.h>


/*****************************************************************************/
#define  WM_SHUTDOWNSERVER        WM_USER + 1001
/*****************************************************************************/
/* Tells application to update the modem lights based on the new data        */
/*                                                                           */
/* MPARAM1                                                                   */
/*     pointer to MWM_MODEM_STATUS                                           */
/*****************************************************************************/
#define  WM_MWMSETMODEMLIGHTS     MWM_LAST_PARSER_MSG_NUM+1  /*Ask Main thread to repaint the modem lights*/

/*****************************************************************************/
/* Window message to Load the modem.                                         */
/*****************************************************************************/
#define  WM_MWMLOADMODEM          MWM_LAST_PARSER_MSG_NUM+2

#define  WM_MWMPOUNDUDTIMER       MWM_LAST_PARSER_MSG_NUM+3  /*Ask Main thread to repaint the modem lights*/

#define IDM_HELPINDEX        1210
#define IDM_OPTIONS          1310
#define IDM_DEBUGWIN         1320
#define IDM_POUNDUDWIN       1330

#define IDM_SPEED            1400
#define IDM_2400             1401   /* grouped items should be separated by 1*/
#define IDM_14400            1402
#define IDM_28800_OR_33600   1403
#define IDM_33600            1404
#define IDM_64000            1405
#define IDM_WARNING          1420
#define IDM_CONCURRENCY      1421

#define IDM_STARTUP          1500
#define IDM_HIDDEN           1520
#define IDM_MWMCANCEL        1610
#define IDM_MWMOK            1620

/*#define IDDLG_ERROR          4000*/
#define IDM_RESTART          4001
#define IDM_CLOSE            4002
#define IDM_DETAILS          4003
#define IDM_ERRORMESSAGE     4004
#define IDM_ERRORINFO        4005
#define IDM_REPAINT          4006
#define IDM_RESIZE           4007

#define IDM_REALLYCLOSE      4100

#define IDM_RESTORE          5000
#define IDM_HIDE             5001
#define IDM_MINIONTOP        5002
#define IDM_ALWAYSONTOP      5003
#define IDM_STARTMINIMIZED   5004
#define IDM_GROUPSPEED       5005
#define IDM_GROUPDISPLAY     5006

#define IDM_X2ONLY           5020
#define IDM_V90ONLY          5021

#define FIRST_STATIC         6000
#define IDC_STATIC00         6000
#define IDC_STATIC01         6001
#define IDC_STATIC02         6002
#define IDC_STATIC03         6003
#define IDC_STATIC04         6004
#define IDC_STATIC05         6005
#define IDC_STATIC06         6006
#define IDC_STATIC07         6007
#define IDC_STATIC08         6008
#define IDC_STATIC09         6009
#define IDC_STATIC10         6010
#define IDC_STATIC11         6011
#define IDC_STATIC12         6012
#define IDC_STATIC13         6013
#define IDC_STATIC14         6014
#define IDC_STATIC15         6015
#define IDC_STATIC16         6016
#define IDC_STATIC17         6017
#define IDC_STATIC18         6018
#define IDC_STATIC19         6019
#define IDC_STATIC20         6020
#define IDC_STATIC21         6021
#define IDC_STATIC22         6022
#define IDC_STATIC23         6023
#define IDC_STATIC24         6024
#define IDC_STATIC25         6025
#define IDC_STATIC26         6026
#define IDC_STATIC27         6027
#define IDC_STATIC28         6028
#define IDC_STATIC29         6029
#define IDC_STATIC30         6030
#define IDC_STATIC31         6031
#define IDC_STATIC32         6032
#define IDC_STATIC33         6033
#define IDC_STATIC34         6034
#define IDC_STATIC35         6035
#define IDC_STATIC36         6036
#define IDC_STATIC37         6037
#define IDC_STATIC38         6038
#define IDC_STATIC39         6039
#define IDC_STATIC40         6040
#define IDC_STATIC41         6041
#define IDC_STATIC42         6042
#define IDC_STATIC43         6043
#define IDC_STATIC44         6044
#define IDC_STATIC45         6045
#define IDC_STATIC46         6046
#define IDC_STATIC47         6047
#define IDC_STATIC48         6048
#define IDC_STATIC49         6049
#define IDC_STATIC50         6050
#define IDC_STATIC51         6051
#define IDC_STATIC52         6052
#define IDC_STATIC53         6053
#define IDC_STATIC54         6054
#define IDC_STATIC55         6055
#define IDC_STATIC56         6056
#define IDC_STATIC57         6057
#define IDC_STATIC58         6058
#define IDC_STATIC59         6059
#define LAST_STATIC          6059


#define IDC_REVISION         6100
#define IDC_CALLSETUPRESULT  6110
#define IDC_MULTIMEDIAMODE   6120
#define IDC_DCEDTEMODE       6130
#define IDC_CM               6140
#define IDC_JM               6150

#define IDC_RECEIVEDPOWER    6200
#define IDC_TRANSMITPOWER    6210
#define IDC_NOISELEVEL       6220
#define IDC_NMSERROR         6230
#define IDC_NEARECHOLOSS     6240
#define IDC_FARECHOLOSS      6250
#define IDC_FARECHODELAY     6260
#define IDC_ROUNDTRIPDELAY   6170
#define IDC_V34INFO          6280


#define IDC_TRANSMITNEGRESULT   6400
#define IDC_RECEIVENEGRESULT    6410
#define IDC_TRANSMITSYMBOLRATE  6420
#define IDC_RECEIVESYMBOLRATE   6430
#define IDC_TRANSMITFREQ        6440
#define IDC_RECEIVEFREQ         6450
#define IDC_INITTRANSMITRATE    6460
#define IDC_INITRECEIVERATE     6470

#define IDC_TEMPLOSSCOUNT       6500
#define IDC_RATERENEGCOUNT      6510
#define IDC_RETRAINSREQUESTED   6520
#define IDC_RETRAINSGRANTED     6530
#define IDC_FINALTRANSMITRATE   6540
#define IDC_FINALRECEIVERATE    6550

#define IDC_PROTOCOLNEGRESULT     6600
#define IDC_ERRORCONTROLFRAMESIZE 6610
#define IDC_ERRORCONTROLLINKTOS   6620
#define IDC_ERRORCONTROLLINKNAKS  6630
#define IDC_COMPRESSIONNEGRESULT  6640
#define IDC_COMPRESSIONDICTSIZE   6650

#define IDC_TRANSMITFLOWCONTROL   6700
#define IDC_RECEIVEFLOWCONTROL    6710
#define IDC_TRANSMITCHARS         6720
#define IDC_RECEIVECHARS          6730
#define IDC_TRANSMITCHARSLOST     6740
#define IDC_RECEIVECHARSLOST      6750
#define IDC_XMITIFRAMES           6760
#define IDC_RECVIFRAMES           6770
#define IDC_XMITIFRAMEERRORS      6780
#define IDC_RECVIFRAMEERRORS      6790

#define IDC_TERMINATIONCAUSE      6800

/* These should be in sequential order*/
#define FIRST_DLG_ID              6901
#define IDC_CALLINFO              6901
#define IDC_PUMPINFO              6902
#define IDC_NEGRESULTS            6903
#define IDC_CARRIERINFO           6904
#define IDC_PROTOCOL              6905
#define IDC_DATAFLOWINFO          6906
#define IDC_TERMINATION           6907
#define LAST_DLG_ID               6907

#define IDC_UPDATENOW             6910
#define IDC_UPDATEFREQ            6920
#define IDC_SETFREQUENCY          6930


#define MWM_INI_FILENAME      "MWMWIN.INI"

#define MWM_NUM_MODEM_LIGHTS   8
#define MWM_NUM_DISPLAY_LINES  2



SHORT             sModemStartSpeed;
PMWM_DSPINFO      pmwmDspInfo;
MWM_INSTANCE_INFO InstanceInfo;


/*****************************************************************************/
/* Code for the following definitions is in mwmodem.C                        */
/*****************************************************************************/
LRESULT FAR PASCAL _export MainWndProc(HWND hwnd, UINT msg,
                                       WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL _export mwmwinOptionsDlgProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL _export mwmwinErrorDlgProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
void DrawBitmap(HDC hdc, HBITMAP hBitmap, short xStart, short yStart,
                short sWidth, short sHeight );

/* Menu-item definitions for the Modem Debug Window*/
#define IDR_DEBUGMENU                    2
#define CMD_FILESAVEBUFFER               1001
#define CMD_FILEEXIT                     1002
#define CMD_EDITCLEARBUFFER              1004
#define CMD_ALWAYSONTOP                  1006
#define CMD_SHOWTIMESTAMP                1008

#define IDR_POUNDUD_MENU                 3
#define CMD_SHOWALL                      1020
#define CMD_HIDEALL                      1025
#define CMD_CASCADE                      1030

