/*
 *   mwmcntnd.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <time.h>

#include <mwmspcfc.h>
#include <mwmcntnd.h>
static char szThisFile[] = "MWMCNTND.C";


ULONG mwmCntndLoadModuleCommon(PMWM_DSPINFO pmwmDspInfo,  char *pszINIEntry,
                               char *pszInstanceName, HMOD *phmod, char *achFile, SHORT sLine,
                               USHORT usMustHave);

int     ModemIsContending = 0;
ULONG   ulModemIsReinstating = 0;

/****************************************************************************/
/* usRadEventCounter was created to fix a bug encountered in tele-gaming    */
/* mode.  It seemed that the first reinstate needed to return a 0 for       */
/* SB to work properly.                                                     */
/****************************************************************************/
USHORT  usRadEventCounter = 0;

ULONG APIENTRY mwmCntndRMClientProc(ULONG  dwConversationId,
                                    USHORT wMessage,
                                    ULONG  lParam,
                                    USHORT wSize,
                                    void FAR *pBuffer)

{
  ULONG              ulRC = 0;
  PMWM_DSPINFO       pmwmDspInfo;
  ULONG              ulAddressSTATUS = 0;
  MWM_MODEM_STATUS   ModemStatus;
  RC                 ulRC2;
  RC                 ulRC3;
  ULONG              ulAddress;
  USHORT             usValue;
  ULONG              ulCurrentCPF = 0;
  ULONG              ulMaxCPF     = 0;
  ULONG              ulDeltaCPF   = 0;
  ULONG              ulDesiredCPF = 0;
  LONG               lCPFDelta    = 0;
  static BOOL        bUARTAsyncHaveBeenLowered = FALSE;
  static BOOL        bV34CyclesLowered = FALSE;
  time_t             lStartTime;
  time_t             lCurrentTime;

   { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndRMClientProc entry\n");  }

  pmwmDspInfo = (PMWM_DSPINFO)dwConversationId;
  switch (wMessage)
  {
    case CLI_CONNECT:
      return(dwConversationId);
    case CLI_DISCONNECT:
      break;
    case mwCfgReleaseService:
      DPF("Received ReleaseService...Priority: %d ", lParam);
      if (lParam >= pmwmDspInfo->ulModemPriority)
      {
        /*********************************************************************/
        /* We are supposed to release the modem modules here                 */
        /* Tell mgr we aren't playing the game                               */
        /*********************************************************************/
        ulRC = ReleaseServiceIgnored;
      }
      else if (lParam >= pmwmDspInfo->ulModemPriority2)
      {
        ulRC = ReleaseServiceIgnored;

        if (!ModemIsContending)
        {
          bV34CyclesLowered = FALSE;
          bUARTAsyncHaveBeenLowered = FALSE;

          ulRC2 = mwmSpcfcQueryModemStatus(pmwmDspInfo,&ModemStatus,&ulAddressSTATUS);

          /***************************************************************
          ** For V.34 Connections (non-enhanced mode only), scale down
          ** V.34's Full-Duplex EC updating
          ****************************************************************/
          if (pmwmDspInfo->usV34RAD) {
            if (!ulRC2) {
              if ( (ModemStatus.usModemLights & 0x20) &&                 /* check for carrier */
                   (ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT) &&  // check for V.34 connect
                   (!pmwmDspInfo->usPCMConnection) &&                    // non-PCM mode or
                   ( (!pmwmDspInfo->bV34EMConnectionEstablished) ||      // non-enhanced mode or
                     (pmwmDspInfo->bV34EMConnectionEstablished && pmwmDspInfo->usV34RAD==2) ) && // enh. mode and INI flag set
                   (!pmwmDspInfo->us17MIPS) ) {                          // only for non-17 MIPS platforms

                /******************************
                ** Set V.34's FDXEXUP_P = 32
                *******************************/
                ulRC3 = dspLabelToAddress( pmwmDspInfo->hmtV34, "FDXECUP_P", &ulAddress );
                if (!ulRC3) {
                  usValue = 32;
                  ulRC3 = dspMemTransfer(pmwmDspInfo->hDSP,
                                         ulAddress, &usValue, 1,
                                         DSP_MEMXFER_DATA_WRITE);

                  if (!ulRC3) {

                    /****************************************
                    ** Wait for FDXEXUP_P+2 to be set to 32
                    *****************************************/
                    time(&lStartTime);
                    do {
                      ulRC3 = dspMemTransfer( pmwmDspInfo->hDSP,
                                              ulAddress+2, &usValue, 1,
                                              DSP_MEMXFER_DATA_READ );
                      time(&lCurrentTime);
                    } while ( (ulRC3 == 0) && (usValue != 32) &&
                              ((lCurrentTime - lStartTime) < 2) ); /* enddo */

                    /****************************************
                    ** Adjust V.34 cycles down by DELTACPFEC
                    *****************************************/
                    if (usValue == 32) {

                      /* Get the current V.34 CPF */
                      ulRC3 = mwmSpcfcGetTaskCPF( pmwmDspInfo,
                                                  pmwmDspInfo->hmtV34,
                                                  &ulCurrentCPF,
                                                  szThisFile,__LINE__);

                      /****************************************************
                      ** Get MAXCPF for V.34. Since we don't do this for
                      ** enhanced mode, we don't care about DELTACPFEM. We
                      ** also don't care about 17 MIPS, so don't worry
                      ** about MAXCPF17.
                      ** 02/24/97 We now care about DELTACPFEM if we are
                      ** connected above 28.8.
                      *****************************************************/
                      if (!ulRC3) {
                        ulRC3 = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                                  "MAXCPF",
                                                  &ulAddress);
                        if (!ulRC3) {
                          ulRC3 = dspMemTransfer( pmwmDspInfo->hDSP,
                                                  ulAddress,
                                                  &ulMaxCPF, 1,
                                                  DSP_MEMXFER_DATA_READ);

                          if ( (!ulRC) && pmwmDspInfo->bV34EMConnectionEstablished) {
                            ulRC3 = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                                       "DELTACPFEM",
                                                       &ulAddress);
                            if (!ulRC3) {
                              ulRC3 = dspMemTransfer( pmwmDspInfo->hDSP,
                                                      ulAddress,
                                                      &ulDeltaCPF, 1,
                                                      DSP_MEMXFER_DATA_READ);
                              if (!ulRC3) {
                                ulMaxCPF += ulDeltaCPF;
                              } /* endif */
                            } /* endif */
                          } /* endif */
                        } /* endif */
                      } /* endif */

                      /* Get the Delta CPF adjustment */
                      if (!ulRC3) {
                        ulRC3 = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                                   "DELTACPFEC",
                                                   &ulAddress);
                      } /* endif */

                      if (!ulRC3) {
                        ulRC3 = dspMemTransfer( pmwmDspInfo->hDSP,
                                                ulAddress,
                                                &ulDeltaCPF, 1,
                                                DSP_MEMXFER_DATA_READ);
                      } /* endif */

                      ulDesiredCPF = ulMaxCPF - ulDeltaCPF;
                      lCPFDelta = (LONG) (((LONG)ulDesiredCPF) - ((LONG)ulCurrentCPF));

                      /* If an adjustment is needed, change the CPF count */
                      if (lCPFDelta != 0) {
                        ulRC3= mwmCntndChangeCPF( pmwmDspInfo,
                                                  pmwmDspInfo->hmtV34,
                                                  lCPFDelta, MWM_NOTREQD);
                        if (!ulRC3) {
                          bV34CyclesLowered = TRUE;
                          ulRC = ReleaseServiceCanReinstate;
                          usRadEventCounter = 2;
                        } /* endif */
                      } /* endif */
                    } /* endif */
                  } /* endif */
                } /* endif */
              } /* endif */
            } /* endif */
          } /* endif */

          if (!ulRC2)
          {
            if ( (ModemStatus.usModemLights & 0x20) &&                 /* check for carrier */
                ((ModemStatus.usProtocol & MWM_STATUS_V42_CONNECT) ||  // check to see
                 (ModemStatus.usProtocol & MWM_STATUS_MNP_CONNECT)) )  // if non-async connect
            {
              ulRC2 = mwmSpcfcLowerUARTAsyncCycles(pmwmDspInfo, ModemStatus.usProtocol);
              if (ulRC2 == 1)               /* if we lowered the cycles */
              {
                ulRC = ReleaseServiceCanReinstate;
                bUARTAsyncHaveBeenLowered = TRUE;
                usRadEventCounter = 2;
              }
            }
            else  //$2
            {
              if ( (ModemStatus.usModemLights & 0x20) &&                 /* check for carrier */
                   (ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT) &&  // check for v.80 mode
                   (pmwmDspInfo->usV80RAD))
              {
                // NOTE:  this really doesn't seem to have any effect, but it's here for
                //        future tweeking if needed???
                ulRC2 = mwmSpcfcLowerUARTV80Cycles(pmwmDspInfo, ModemStatus.usProtocol);
                if (ulRC2 == 1)               /* if we lowered the cycles */
                {
                  ulRC = ReleaseServiceCanReinstate;
                  bUARTAsyncHaveBeenLowered = TRUE;
                }
              }
            }
          }
        }
      }
      break;

    case mwCfgReinstateService:
      DPF("Received ReinstateService...Priority: %d ", lParam);
      if ( (lParam == pmwmDspInfo->ulModemPriority2) &&
           (bV34CyclesLowered || bUARTAsyncHaveBeenLowered) ) {
        if (usRadEventCounter == 2) {
          usRadEventCounter--;
          ulRC = 0;
        }
        else
        {

          /***************************************************
          ** At the next reinstate, raise V.34 cycles if they
          ** were lowered and raise UART/Async cycles if they
          ** were lowered.
          ****************************************************/
          if (bV34CyclesLowered) {
            if (pmwmDspInfo->hmtV34) {
              ulModemIsReinstating = 1;

              /* Get the current V.34 CPF */
              ulRC3 = mwmSpcfcGetTaskCPF( pmwmDspInfo,
                                          pmwmDspInfo->hmtV34,
                                          &ulCurrentCPF,
                                          szThisFile,__LINE__);

              /* Get MAXCPF for V.34. Since we don't do this for
                 enhanced mode, we don't care about DELTACPFEM.
                 02/24/97 We now care about DELTACPFEM if we are
                 connected above 28.8.                           */
              if (!ulRC3) {
                ulRC3 = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                           "MAXCPF",
                                           &ulAddress);
                if (!ulRC3) {
                  ulRC3 = dspMemTransfer( pmwmDspInfo->hDSP,
                                          ulAddress,
                                          &ulMaxCPF, 1,
                                          DSP_MEMXFER_DATA_READ);
                  if (!ulRC3) {
                    if ( (!ulRC) && pmwmDspInfo->bV34EMConnectionEstablished) {
                      ulRC3 = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                                 "DELTACPFEM",
                                                 &ulAddress);
                      if (!ulRC3) {
                        ulRC3 = dspMemTransfer( pmwmDspInfo->hDSP,
                                                ulAddress,
                                                &ulDeltaCPF, 1,
                                                DSP_MEMXFER_DATA_READ);
                        if (!ulRC3) {
                          ulMaxCPF += ulDeltaCPF;
                        } /* endif */
                      } /* endif */
                    } /* endif */
                  } /* endif */

                  if (!ulRC3) {
                    // Increase the cycles
                    ulDesiredCPF = ulMaxCPF;
                    lCPFDelta = (LONG) (((LONG)ulDesiredCPF) - ((LONG)ulCurrentCPF));

                    /* If an adjustment is needed, change the CPF count */
                    if (lCPFDelta != 0) {
                      ulRC3 = mwmCntndChangeCPF( pmwmDspInfo,
                                                 pmwmDspInfo->hmtV34,
                                                 lCPFDelta, MWM_MUSTHAVE);
                    } /* endif */
                  } /* endif */
                } /* endif */
              } /* endif */

              // Change the required label.
              if (!ulRC3) {
                ulRC3 = dspLabelToAddress( pmwmDspInfo->hmtV34, "MIN_FDXECUP_P", &ulAddress );
                if (!ulRC3) {
                  ulRC3 = dspMemTransfer(pmwmDspInfo->hDSP,
                                         ulAddress, &usValue, 1,
                                         DSP_MEMXFER_DATA_READ);
                  if (!ulRC3) {
                    ulRC3 = dspLabelToAddress( pmwmDspInfo->hmtV34, "FDXECUP_P", &ulAddress );
                    if (!ulRC3) {
                      ulRC3 = dspMemTransfer(pmwmDspInfo->hDSP,
                                             ulAddress, &usValue, 1,
                                             DSP_MEMXFER_DATA_WRITE);
                      if (!ulRC3) {
                        bV34CyclesLowered = FALSE;
                        ulModemIsReinstating = 0;
                        ulRC = 1;
                      } /* endif */
                    } /* endif */
                  } /* endif */
                } /* endif */
              } /* endif */

              if (ulRC3) {
                ulRC = 0;
              } /* endif */

            } else { // No V.34 present
              bV34CyclesLowered = FALSE;
              ulModemIsReinstating = 0;
              ulRC = 1;
            } /* endif */
          } /* endif */

          if (bUARTAsyncHaveBeenLowered) {
            if (!bV34CyclesLowered) {
              if (!pmwmDspInfo->ulDiscrimState) {               /* check for carrier */

                ulRC2 = mwmSpcfcQueryModemStatus(pmwmDspInfo,&ModemStatus,&ulAddressSTATUS);
                if (!ulRC2) {
                  ulModemIsReinstating = 1;

                  if (!(ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT)) {
                    ulRC3 = mwmSpcfcRaiseUARTAsyncCycles(pmwmDspInfo, ModemStatus.usProtocol, MWM_NOTREQD);    //$3
                  } else {
                    ulRC3 = mwmSpcfcRaiseUARTV80Cycles(pmwmDspInfo, ModemStatus.usProtocol);
                  } /* endif */

                  // Assume the increase went OK
                  bUARTAsyncHaveBeenLowered = FALSE;
                  usRadEventCounter = 0;

                  // If the increase was successful and we are not waiting
                  // for the V.34 cycles to increase, then indicate success.
                  if (ulRC3 == 0) {
                    if (!bV34CyclesLowered) {
                      ulRC = 1;
                    } /* endif */

                  // If the increase failed and we are waiting for the
                  // V.34 cycles to increase, then we can try to increase
                  // the UART/Async cycles when we next try to increase
                  // the V.34 cycles.
                  } else {
                    if (bV34CyclesLowered) {
                      bUARTAsyncHaveBeenLowered = TRUE;

                    // If the increase failed and we are not waiting for
                    // the V.34 cycle increase, then indicate success anyway.
                    } else {
                      ulRC = 1;
                    } /* endif */
                  } /* endif */

                  ulModemIsReinstating = 0;

                } /* endif */

              } else {
                ulRC = 1;
              } /* endif */
            } /* endif */
          } /* endif */
        }
      } else {
        ulRC = 1;
      } /* endif */
    break;

  } /* endswitch */

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndRMClientProc exit\n");  }

  return ulRC;
}

/*****************************************************************************/
/* MTS RADD Add resource management calls                                    */
/* Tell mwContend whether we were successful or not                          */
/*                                                                           */
/*  OK_flag = 1 for successful load, 0 for failure                           */
/*****************************************************************************/
ULONG mwmCntndLoadComplete(PMWM_DSPINFO pmwmDspInfo, int OK_flag)
{

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadComplete entry\n");  }


  DPF("All loaded: %d ", OK_flag);

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadComplete exit\n");  }

  return 0;
}

/*****************************************************************************/
/* MTS RADD Add resource management calls                                    */
/* Tell mwContend that our load failed.  This will kick off lower            */
/* priority functions and should allow our load to work.                     */
/*****************************************************************************/
ULONG mwmCntndContend(PMWM_DSPINFO pmwmDspInfo, ULONG ulRC)
{

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndContend entry\n");  }

  ulRC = 0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndContend exit\n");  }


  return ulRC;
}

ULONG mwmCntndLoadTask(PMWM_DSPINFO pmwmDspInfo,  char *pszINIEntry,
                       char *pszTaskName,         char *pszInstanceName,
                       HMOD hmod,                 HMTASK *phTask,
                       char *achFile,             SHORT sLine)
{
   int     iSuccess;
   ULONG   ulRC;
   char    achDSPFileName[MWM_MAX_FILENAME_LENGTH];
   int     numTries=1, retry=0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadTask entry\n");  }


   memset(achDSPFileName,0,MWM_MAX_FILENAME_LENGTH);

  iSuccess= GetPrivateProfileString("COMMFILE",pszINIEntry, "none",
                                    achDSPFileName,
                                    MWM_MAX_FILENAME_LENGTH,(PSZ)INIFile);
  if ((iSuccess == 0)||((strcmp("none",achDSPFileName))==0))
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_OS_ERROR,
                   0 );
    return (1);
  }

  /*****************************************************************************/
  /* Any environment but OS/2....                                              */
  /*****************************************************************************/

  do
  {
    ulRC = dspLoadTask(hmod,
                       pmwmDspInfo->hDSP,           // hDSP
                       achDSPFileName,     //  filename to .DSP file.
                       pszTaskName,
                       pszInstanceName,                     // pszInstanceName
                       DSP_ACTIVATE_STANDBY,         // usLoadFlags
                       NULL,
                       phTask);   // returned phMod

    if (ulRC != DSP_NOERROR)
    {
      if (ulRC == 3)
      {
        mwmHandleError(pInstanceInfo, achFile,sLine, MWM_USER_MESSAGE, MWM_STR_DSP_FILE_NOT_FOUND );
        return(ulRC);
      }
      else
      {
        if (numTries==1 )
        {
           ulRC = mwmCntndContend(pmwmDspInfo, ulRC);          /* MTS RADD */
           retry=1;
        }
        if (ulRC != DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo, achFile, sLine,
                         MWM_DSP_ERROR,
                         ulRC);
          break;
        }
      }
    }
  } while (numTries++ < 2 && retry == 1);


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadTask exit\n");  }


  return ulRC;
}



ULONG mwmCntndLoadModule(PMWM_DSPINFO pmwmDspInfo,  char *pszINIEntry,
                         char *pszInstanceName, HMOD *phmod, char *achFile, SHORT sLine)
{
  ULONG ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadModule entry\n");  }

  ulRC = mwmCntndLoadModuleCommon( pmwmDspInfo, pszINIEntry, pszInstanceName,
                                   phmod, achFile, sLine, MWM_MUSTHAVE );

  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadModule exit ulRC %lx\n",ulRC);  }

  return(ulRC);
}

ULONG mwmCntndLoadModuleOptional(PMWM_DSPINFO pmwmDspInfo,  char *pszINIEntry,
                                  char *pszInstanceName, HMOD *phmod, char *achFile,
                                  SHORT sLine, USHORT usMustHave)
{
  ULONG ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadModuleOptional entry\n");  }


  ulRC = mwmCntndLoadModuleCommon( pmwmDspInfo, pszINIEntry, pszInstanceName,
                                   phmod, achFile, sLine, usMustHave );

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadModuleOptional exit\n");  }

  return(ulRC);
}

ULONG mwmCntndLoadModuleCommon(PMWM_DSPINFO pmwmDspInfo,  char *pszINIEntry,
                               char *pszInstanceName, HMOD *phmod, char *achFile, SHORT sLine,
                               USHORT usMustHave)
{
   int     iSuccess;
   ULONG   ulRC;
   char    achDSPFileName[MWM_MAX_FILENAME_LENGTH];
   int     numTries=1, retry=0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadModuleCommon entry\n");  }
  { MW_SYSLOG_4(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadModuleCommon pszINIEntry=%s pszInstanceName=%s achFile=%s\n", pszINIEntry, pszInstanceName, achFile);  }


  memset(achDSPFileName,0,MWM_MAX_FILENAME_LENGTH);
  iSuccess= GetPrivateProfileString("COMMFILE",pszINIEntry, "none",
                                    achDSPFileName,
                                    MWM_MAX_FILENAME_LENGTH,(PSZ)INIFile);
  if ((iSuccess == 0)||((strcmp("none",achDSPFileName))==0))
  {
    mwmHandleError(pInstanceInfo,achFile,sLine,
                   MWM_OS_ERROR,
                   0 );
    return (1);
  }

  do
  {
    ulRC = dspLoadModule(pmwmDspInfo->hDSP,           // hDSP
                         achDSPFileName,     // Fully Qualified filename to .DSP file.
                         pszInstanceName,                     // pszInstanceName
                         DSP_ACTIVATE_STANDBY,         // usLoadFlags
                         phmod);   // returned phMod
    if (ulRC != DSP_NOERROR)
    {
      if (ulRC == 3)
      {
        mwmHandleError(pInstanceInfo, achFile, sLine, MWM_USER_MESSAGE, MWM_STR_DSP_FILE_NOT_FOUND );
        return(ulRC);
      }
      else
      {
        if (numTries==1 )
        {
           ulRC = mwmCntndContend(pmwmDspInfo, ulRC);          /* MTS RADD */

           if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
           {
             (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"radfail.snp");
           }

           retry=1;
        }
        if (ulRC != DSP_NOERROR)
        {
          if (usMustHave == MWM_MUSTHAVE) {
            mwmHandleError(pInstanceInfo,achFile,sLine,
                           MWM_DSP_ERROR,
                           ulRC);
            break;
          } /* endif */
        }
      }
    }
  } while (numTries++ < 2 && retry == 1);


  /***************************************************************************/
  /* Get the version information from both the INI file, and from the        */
  /* newly loaded .DSP module.                                               */
  /***************************************************************************/

   if (!ulRC)
     ulRC = mwmSpcfcAddToVersionList(pmwmDspInfo,
                                     achDSPFileName,
                                     *phmod,
                                     pszINIEntry,
                                     INIFile);

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadModuleCommon exit\n");  }

  return ulRC;
}

ULONG mwmCntndLoadSegment(PMWM_DSPINFO pmwmDspInfo,
                          char  *pszINIEntry,
                          char  *pszSegmentName,
                          char  *pszInstanceName,
                          HMTASK  hTask,
                          HSEG  *phSeg,
                          ULONG  ulDSPAddr,
                          char  *achFile, SHORT sLine,
                          USHORT usMustHave)
{
   int     iSuccess;
   ULONG   ulRC;
   char    achDSPFileName[MWM_MAX_FILENAME_LENGTH];
   int     numTries=1, retry=0;


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadSegment entry\n");  }


  memset(achDSPFileName,0,MWM_MAX_FILENAME_LENGTH);
  iSuccess= GetPrivateProfileString("COMMFILE",pszINIEntry, "none",
                                    achDSPFileName,
                                    MWM_MAX_FILENAME_LENGTH,(PSZ)INIFile);
  if ((iSuccess == 0)||((strcmp("none",achDSPFileName))==0))
  {
    mwmHandleError(pInstanceInfo,achFile,sLine,
                   MWM_OS_ERROR,
                   0 );
    return (1);
  }

  do
  {
    ulRC = dspLoadSegment(hTask,
                         achDSPFileName,     // Fully Qualified filename to .DSP file.
                         pszSegmentName,                     // pszInstanceName
                         pszInstanceName,                     // pszInstanceName
                         ulDSPAddr,
                         phSeg);   // returned phSeg

    if (ulRC != DSP_NOERROR)
    {
      if (ulRC == 3)
      {
        mwmHandleError(pInstanceInfo, achFile, sLine , MWM_USER_MESSAGE, MWM_STR_DSP_FILE_NOT_FOUND );
        return(ulRC);
      }
      else
      {
        if (numTries==1 )
        {
           ulRC = mwmCntndContend(pmwmDspInfo, ulRC);          /* MTS RADD */
           retry=1;
        }
        if ((ulRC != DSP_NOERROR) && (usMustHave == MWM_MUSTHAVE))
        {
          mwmHandleError(pInstanceInfo,achFile,sLine,
                         MWM_DSP_ERROR,
                         ulRC);
          break;
        }
      }
    }
  } while (numTries++ < 2 && retry == 1);


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndLoadSegment exit\n");  }


  return ulRC;
}

ULONG mwmCntndAllocSegment(PMWM_DSPINFO pmwmDspInfo,
                           HMTASK   hTask,
                           char * pszInstanceName,
                           ULONG  ulSize,
                           ULONG  ulAlign,
                           ULONG  ulDSPAddr,
                           PHSEG  phSeg
                           )
{
  int     numTries=1, retry=0;
  ULONG   ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndAllocSegment entry\n");  }

  do
  {
    ulRC = dspAllocateSegment(hTask,
                              pszInstanceName,
                              ulSize,
                              ulAlign,
                              SEG_DATA,
                              ulDSPAddr,
                              phSeg);
    if (ulRC != DSP_NOERROR)
    {
      if (numTries==1 )
      {
         ulRC = mwmCntndContend(pmwmDspInfo, ulRC);          /* MTS RADD */
         retry=1;
      }
      if (ulRC != DSP_NOERROR)
        break;                  /* no contend server or failed on 2nd pass */
    }
  } while (numTries++ < 2 && retry == 1);

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndAllocSegment exit\n");  }


  return ulRC;
}


ULONG mwmCntndChangeCPF(PMWM_DSPINFO pmwmDspInfo,
                        HMTASK   hTask,
                        LONG   lCPFDelta,
                        USHORT  usMustHave)
{
  int     numTries=1, retry=0;
  ULONG   ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndChangeCPF entry\n");  }

  do
  {
    ulRC=dspChangeCPF(hTask, lCPFDelta);
    DPF("Change CPF %ld rc=%lx", lCPFDelta, ulRC);
    if (ulRC == DSP_INSUFF_CPS && usMustHave == MWM_MUSTHAVE)
    {
      if (numTries==1 )
      {
         ulRC = mwmCntndContend(pmwmDspInfo, ulRC);          /* MTS RADD */
         retry=1;
      }
      if (ulRC != DSP_NOERROR)
        break;                  /* no contend server or failed on 2nd pass */
    }
  } while (numTries++ < 2 && retry == 1);

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndChangeCPF exit\n");  }


  return ulRC;
}
/*****************************************************************************/
/*                                                                           */
/*  usMusthave = MWM_MUSTHAVE or MWM_NOTREQD                                 */
/*  pusFailed = ptr to return code status, since ulrc may be 0 on failure    */
/*                                                                           */
/*****************************************************************************/
ULONG mwmCntndSetUART(PMWM_DSPINFO pmwmDspInfo, LONG Value, USHORT usMustHave,
                      PUSHORT pusFailed, char *achFile, SHORT sLine)
{
  int     numTries=1, retry=0;
  ULONG   ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndSetUART entry\n");  }

  *pusFailed=1;         /* assume it will fail */
  do
  {
    ulRC = dspMeioUpdateConnection(pmwmDspInfo->hConnectUart,
                                   MEIO_CONNECTION_CHARACTERISTICS,
                                   Value);
    DPF("Set UART Value %ld rc=%lx", Value, ulRC);
    if (ulRC && usMustHave)
    {
      if (numTries==1 )
      {
         ulRC = mwmCntndContend(pmwmDspInfo, ulRC);          /* MTS RADD */
         retry=1;
      }
      if (ulRC != DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,achFile, sLine,
                       MWM_MEIO_ERROR, ulRC );
        break;          /* no contend server or failed on 2nd pass */
      }
    }
    else if (ulRC)   /* musthave = 0 */
    {
       if ((ulRC> 0xffff) && (((USHORT)ulRC) == DSP_INSUFF_CPS))
         ulRC = 0; /* Insufficient cycles is not a fatal error, so return 0 */
       else
        mwmHandleError(pInstanceInfo,achFile, sLine,
                       MWM_MEIO_ERROR, ulRC );
    }
    else
      *pusFailed=0;         /* it worked */
  } while (numTries++ < 2 && retry == 1);

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndSetUART exit\n");  }


  return ulRC;
}

RC mwmCntndConnectGPC(HMTASK hOwnerTask, PSZ  pszOwner,
                      HMTASK hUserTask, PSZ  pszUser,
                      USHORT usProtocol, PULONG pulDSPAddr,
                      PMWM_DSPINFO pmwmDspInfo,
                      char *achFile, SHORT sLine)
{
  int     numTries=1, retry=0;
  ULONG   ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndConnectGPC entry\n");  }


  do
  {
    ulRC = dspConnectGPC(hOwnerTask, pszOwner, hUserTask, pszUser,
                         usProtocol, pulDSPAddr);

    if (ulRC != DSP_NOERROR)
    {
      if (numTries==1 )
      {
         ulRC = mwmCntndContend(pmwmDspInfo, ulRC);          /* MTS RADD */
         retry=1;
      }
      if (ulRC != DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,achFile, sLine,
                       MWM_DSP_ERROR, ulRC);
        break;
      }
    }
  } while (numTries++ < 2 && retry == 1);


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndConnectGPC exit\n");  }


  return ulRC;
}

RC mwmCntndMEIOConnect(HCONNECTION FAR *pConnection, ULONG OwnerPort,
                       ULONG UserPort, ULONG SharingOptions,
                       ULONG ulState, ULONG Reserved,
                       PMWM_DSPINFO pmwmDspInfo,
                       ULONG errRC,
                       char *achFile, SHORT sLine)
{
  int     numTries=1, retry=0;
  ULONG   ulRC;

  { MW_SYSLOG_7(TRACE_MWMLW32,"mwmcntnd::mwmCntndMEIOConnect entry hMEIO %lx pConnection %p OwnerPort %lx UserPort %lx SharingOptions %lx ulState %lx\n",
	hMEIO,pConnection,OwnerPort,UserPort,SharingOptions,ulState);  }


  do
  {
    ulRC = dspMeioConnect(hMEIO,pConnection,OwnerPort,UserPort,
             SharingOptions,ulState, Reserved);
     { MW_SYSLOG_2(TRACE_MWMLW32,"mwmcntnd::mwmCntndMEIOConnect, return from dspMeioConnect ulRC %lx\n",ulRC);  }
    if (ulRC != MEIO_NOERROR)    // Check the error codes
    {
      if (numTries==1 )
      {
	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndMEIOConnect, calling mwmCntndContend\n");  }
         ulRC = mwmCntndContend(pmwmDspInfo, ulRC);          /* MTS RADD */
	 { MW_SYSLOG_2(TRACE_MWMLW32,"mwmcntnd::mwmCntndMEIOConnect, return from mwmCntndContend ulRC %lx\n",ulRC);  }
         retry=1;
      }
      if (ulRC != MEIO_NOERROR)
      {
        switch (ulRC)
        {
           case MEIO_NC_CONNECTION_BLOCKED:
           case MEIO_NC_OWNER_BLOCKED:
           case MEIO_NC_USER_BLOCKED:
              if(errRC)
                 mwmHandleError(pInstanceInfo, achFile, sLine,
                                MWM_USER_MESSAGE, errRC );
              else
                 mwmHandleError(pInstanceInfo, achFile, sLine,
                                MWM_MEIO_ERROR, ulRC );
              break;

           default:               // Anything else
              mwmHandleError(pInstanceInfo, achFile, sLine,
                             MWM_MEIO_ERROR, ulRC );
              break;
        } /* endswitch */
        break;
      }
    }
  } while (numTries++ < 2 && retry == 1);

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcntnd::mwmCntndMEIOConnect exit\n");  }



  return ulRC;
}

