/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2018  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
namespace Pasang {

class GameMenu : Gtk.ScrolledWindow {
    public signal void activated (int row);

    public BrainSetter brain_setter = new BrainSetter ();

	public GameMenu (Client client) {
        var content_box = new Gtk.Box (Gtk.Orientation.VERTICAL, 10);
        content_box.pack_start (create_fixed_items (), false, false);
        content_box.pack_start (client.menu, false, false);
        content_box.get_style_context () .add_class ("box-top-level");

        var padding_box = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 0);
        padding_box.pack_start (new Gtk.Label (""));
        padding_box.pack_start (content_box);
        padding_box.pack_start (new Gtk.Label (""));

        add (padding_box);
		set_policy (Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC);
	}

    /**
     * Create "Play Against ..." menu items that are fixed
     */
    private Gtk.Widget create_fixed_items () {
        var list_box = new Gtk.ListBox ();
        list_box.add (create_item (_("Play Against Machine"), create_brain_setter_button ()));
        list_box.add (create_item (_("Play Face to Face")));
        list_box.add (create_item (_("Demo")));
        list_box.selection_mode = Gtk.SelectionMode.NONE;
        list_box.row_activated.connect ((row) => {
            activated (row.get_index ());
        });
        list_box.get_style_context () .add_class ("listbox-menu");
        return list_box;
    }

    /**
     * Create a gear button to pop up AI configuration
     */
    private Gtk.Widget create_brain_setter_button () {
        var button = new Gtk.MenuButton ();
        button.image = new Gtk.Image.from_icon_name ("emblem-system-symbolic", Gtk.IconSize.BUTTON);
        button.tooltip_text = _("Configure the machine");
        var popover = new Gtk.Popover (button);
        popover.modal = true;
        popover.add (brain_setter);
        button.popover = popover;
        return button;
    }

    /**
     * Create a Box like this
     *    +------------------------+
     *    |  Label         widget  |
     *    +------------------------+
     */
    public static Gtk.Widget create_item (string text, Gtk.Widget? widget = null) {
        var box = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 0);
        var label = new Gtk.Label (text);
        box.pack_start (label, false, false, 0);
        if (widget != null) {
            widget.valign = Gtk.Align.CENTER;
            box.pack_end (widget, false, false, 0);
        }
        box.get_style_context () .add_class ("listbox-menu-item");
        return box;
    }

}//class
}//namespace

// vim: tabstop=4: expandtab: textwidth=100: autoindent:
