/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Collections;
import java.util.List;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.analyses.UnboxableOpsAnalysisProblem;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;

public class UnboxingPass
extends CompilerPass {
    public static final List<Class<? extends CompilerPass>> DEPENDENCIES = Collections.singletonList(LiveVariableAnalysis.class);

    @Override
    public String getLabel() {
        return "Unboxing Pass";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(FullInterpreterContext fic, Object ... data2) {
        UnboxableOpsAnalysisProblem problem = new UnboxableOpsAnalysisProblem();
        problem.setup(fic);
        problem.compute_MOP_Solution();
        problem.unbox();
        new LiveVariableAnalysis().invalidate(fic);
        return true;
    }

    @Override
    public Object previouslyRun(FullInterpreterContext fic) {
        return fic.getDataFlowProblems().get("UnboxableOpsAnalysis");
    }

    public boolean invalidate(IRScope scope) {
        return false;
    }
}

