/**********************************************************************
 *
 *    FILE:            LightSource.cpp
 *
 *    DESCRIPTION:    Read/Write osg::LightSource in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 21.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "LightSource.h"
#include "Group.h"
#include "Light.h"

using namespace ive;

void LightSource::write(DataOutputStream* out){
    // Write LightSource's identification.
    out->writeInt(IVELIGHTSOURCE);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Group*  group = dynamic_cast<osg::Group*>(this);
    if(group){
        ((ive::Group*)(group))->write(out);
    }
    else
        out_THROW_EXCEPTION("LightSource::write(): Could not cast this osg::LightSource to an osg::Group.");
    // Write LightSource's properties.

    // Write out light
    out->writeBool(getLight()!=0);
    if(getLight())
        {
        ((ive::Light*)(getLight()))->write(out);
    }

    // Write reference frame
    out->writeInt((int)getReferenceFrame());
}

void LightSource::read(DataInputStream* in){
    // Peek on LightSource's identification.
    int id = in->peekInt();
    if(id == IVELIGHTSOURCE){
        // Read LightSource's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Group*  group = dynamic_cast<osg::Group*>(this);
        if(group){
            ((ive::Group*)(group))->read(in);
        }
        else
            in_THROW_EXCEPTION("LightSource::read(): Could not cast this osg::LightSource to an osg::Object.");
        // Read LightSource's properties

        // Read light
        if(in->readBool()){
            osg::Light* light = new osg::Light();
            ((ive::Light*)(light))->read(in);
            setLight(light);
        }

        // Read reference frame
        setReferenceFrame((osg::LightSource::ReferenceFrame) in->readInt());
    }
    else{
        in_THROW_EXCEPTION("LightSource::read(): Expected LightSource identification.");
    }
}
