#!/bin/sh

#-----------------------------------------------------------------------
# The directory where this script resides is considered the EXPANDER_DIR
#-----------------------------------------------------------------------
expDir=`echo $0|grep /`

if [ "$expDir" = "" ]; then
    expDir=`pwd`         # in the directory already
else
    expDir=`dirname $0`  # executing from elsewhere
fi

#----------------------
# Required definitions.
#----------------------
EXPANDER_DIR=$expDir;                     export EXPANDER_DIR
EXPANDER_DEF=$expDir/defs;                export EXPANDER_DEF
EXPANDER_TPL=$expDir/templates;           export EXPANDER_TPL
EXP_DEFINITIONS=$expDir/defs/definitions; export EXP_DEFINITIONS
EXP_NO_AUTOFIELD="yes";                   export EXP_NO_AUTOFIELD

# Optional configuration parameters (shown with current defaults)
#-----------------------------------------------------------------
# EXP_DATE_FORMAT="%b %d, %Y";            export EXP_DATE_FORMAT
# EXP_TIME_FORMAT="%H:%M:%S";             export EXP_TIME_FORMAT
# EXP_DTIME_FORMAT="%b %d, %Y %H:%M:%S";  export EXP_DTIME_FORMAT
# EXP_INDENT_SIZE=4;                      export EXP_INDENT_SIZE
# EXP_USE_TABS=0;                         export EXP_USE_TABS
# EXP_KEYWORD_DELIM=" \t";                export EXP_KEYWORD_DELIM
# EXP_EXTENT=".def";                      export EXP_EXTENT
# EXP_USER="$LOGNAME";                    export EXP_USER
#-----------------------------------------------------------------
