/*
 * bmon - bandwidth monitor
 *
 * bmon is a bandwidth with 3 modes (overview, graphical, detailed). the
 * overview mode shows a list of all interfaces and the corresponding
 * byte/packet rates per second. The graphical mode displays the bandwidth
 * usage of the last 60 [seconds/minutes/hours] in a mrtg like format.
 * The detailed mode prints out values like errors, dropps, frames etc.
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 *
 */

#include <stdio.h>
#include <curses.h>
#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>

#include "../config.h"

#include "curs_util.h"
#include "intf.h"

static int quit_done = 0;

time_t now  = 0;

int do_resolve = 0;
char dname[255];

RETSIGTYPE
finish(int sig)
{
    exit(0);
}

void
doexit(void)
{
    if (!quit_done)
        endwin();
    quit_done=1;
}

void
quit(const char *fmt, ...)
{
    va_list args;

    doexit();

    va_start(args, fmt);
    vfprintf(stderr, fmt, args);
    va_end(args);

    exit(-1);
}

void
draw(void)
{
    row = 0;
    intf_draw();
    print_status("bmon");
    refresh();
}

int
main(int argc, char *argv[])
{
    time_t bt = time(0);

    atexit(&doexit);

    if (signal(SIGINT, finish) < 0) {   /* clean exit upon interrupt */
        perror("signal");
        finish(-1);
    }

    curs_init();

    for (;;) {

        now = time(0);

        for (;;) {

            int ch = getch();

            if (ch == 'q')
                finish(0);
            else if (ch == 12) {
                clear();
                draw();
            }

            if ( intf_handle_input(ch) )
                draw();

            if (ch == -1)
                break;
        }

        /*
         * calculate and display stuff at least once a second
         */
        if ( (now - bt) >= 1) {
            intf_readfile("/proc/net/dev");
            draw();
            bt = now;
        }

        usleep(20000);
    }

    return 0; /* will never be reached */
}
