      SUBROUTINE ARC(ANGX,ANGY,ANGZ)
C
      INCLUDE 'com_faces.f'
      DATA EPS /1.E-9/
      DATA CQVSPI / 57.2957795130823  /
C
      IF (ABS(1.-ROTA(1,3)**2).LT.EPS) THEN
        IF (ROTA(1,3).GT.0.) THEN
          ANGY = 90.
        ELSE
          ANGY = -90.
        ENDIF
        ANGX = .5*DEGRE(-ROTA(3,1),ROTA(2,1))
        ANGZ = ANGX
      ELSE
        ANGY = ASIN(ROTA(1,3))*CQVSPI
        ANGX = DEGRE(ROTA(3,3),-ROTA(2,3))
        ANGZ = DEGRE(ROTA(1,1),-ROTA(1,2))
      ENDIF
      END
C------------------------------------------------------------
      REAL FUNCTION DEGRE(CO,SI)
      DATA CQVSPI /  57.2957795130823 /
C
      DEGRE = CQVSPI*ATAN2(SI,CO)
C
      END
C------------------------------------------------------------
      SUBROUTINE ARCROT(ANGX,ANGY,ANGZ)
C
      INCLUDE 'com_faces.f'
      DATA PI180 / .0174523925199433  /
C
      ANGX = ANGX*PI180
      ANGY = ANGY*PI180
      ANGZ = ANGZ*PI180
      COSX = COS(ANGX)
      SINX = SIN(ANGX)
      COSY = COS(ANGY)
      SINY = SIN(ANGY)
      COSZ = COS(ANGZ)
      SINZ = SIN(ANGZ)
      ROTA(1,1) = COSY*COSZ
      ROTA(2,1) = COSX*SINZ + SINX*SINY*COSZ
      ROTA(3,1) = SINX*SINZ - COSX*SINY*COSZ
      ROTA(1,2) = -COSY*SINZ
      ROTA(2,2) = COSX*COSZ - SINX*SINY*SINZ
      ROTA(3,2) = SINX*COSZ + COSX*SINY*SINZ
      ROTA(1,3) = SINY
      ROTA(2,3) = -SINX*COSY
      ROTA(3,3) = COSX*COSY
C      
      END
