"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getXAxisRightOverflow = void 0;
var scales_1 = require("../../../../scales");
var constants_1 = require("../../../../scales/constants");
var create_selector_1 = require("../../../../state/create_selector");
var canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
var get_heatmap_config_1 = require("./get_heatmap_config");
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var get_heatmap_table_1 = require("./get_heatmap_table");
exports.getXAxisRightOverflow = (0, create_selector_1.createCustomCachedSelector)([get_heatmap_spec_1.getHeatmapSpecSelector, get_heatmap_config_1.getHeatmapConfigSelector, get_heatmap_table_1.getHeatmapTableSelector], function (_a, _b, _c) {
    var xScale = _a.xScale;
    var timeZone = _b.timeZone, _d = _b.xAxisLabel, fontSize = _d.fontSize, fontFamily = _d.fontFamily, padding = _d.padding, formatter = _d.formatter, width = _d.width;
    var xNumericExtent = _c.xNumericExtent;
    return xScale.type !== constants_1.ScaleType.Time
        ? 0
        : typeof width === 'number'
            ? width / 2
            : (0, canvas_text_bbox_calculator_1.withTextMeasure)(function (measure) {
                return new scales_1.ScaleContinuous({ type: constants_1.ScaleType.Time, domain: xNumericExtent, range: [0, 1] }, { timeZone: xScale.type === constants_1.ScaleType.Time ? timeZone : undefined })
                    .ticks()
                    .reduce(function (max, n) { return Math.max(max, measure(formatter(n), padding, fontSize, fontFamily).width + padding); }, 0);
            }) / 2;
});
//# sourceMappingURL=get_x_axis_right_overflow.js.map