"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLegendLabels = void 0;
var group_by_rollup_1 = require("./group_by_rollup");
function getLegendLabels(layers, tree, legendMaxDepth) {
    return flatSlicesNames(layers, 0, tree).filter(function (_a) {
        var depth = _a.depth;
        return depth <= legendMaxDepth;
    });
}
exports.getLegendLabels = getLegendLabels;
function flatSlicesNames(layers, depth, tree, keys) {
    var e_1, _a;
    var _b;
    if (keys === void 0) { keys = new Map(); }
    if (tree.length === 0) {
        return [];
    }
    try {
        for (var tree_1 = __values(tree), tree_1_1 = tree_1.next(); !tree_1_1.done; tree_1_1 = tree_1.next()) {
            var _c = __read(tree_1_1.value, 2), key = _c[0], arrayNode = _c[1];
            var layer = layers[depth - 1];
            var formatter = layer === null || layer === void 0 ? void 0 : layer.nodeLabel;
            var formattedValue = formatter ? formatter(key) : "" + key;
            if (formattedValue && formattedValue !== group_by_rollup_1.HIERARCHY_ROOT_KEY) {
                keys.set(formattedValue, Math.max(depth, (_b = keys.get(formattedValue)) !== null && _b !== void 0 ? _b : 0));
            }
            var children = arrayNode[group_by_rollup_1.CHILDREN_KEY];
            flatSlicesNames(layers, depth + 1, children, keys);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (tree_1_1 && !tree_1_1.done && (_a = tree_1.return)) _a.call(tree_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return __spreadArray([], __read(keys.keys()), false).map(function (k) {
        var _a;
        return ({
            label: k,
            depth: (_a = keys.get(k)) !== null && _a !== void 0 ? _a : 0,
        });
    });
}
//# sourceMappingURL=legend_labels.js.map