"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DARK_THEME = void 0;
var common_1 = require("../common");
var colors_1 = require("./colors");
var theme_common_1 = require("./theme_common");
exports.DARK_THEME = {
    chartPaddings: theme_common_1.DEFAULT_CHART_PADDING,
    chartMargins: theme_common_1.DEFAULT_CHART_MARGINS,
    lineSeriesStyle: {
        line: {
            visible: true,
            strokeWidth: 1,
            opacity: 1,
        },
        point: {
            visible: true,
            strokeWidth: 1,
            fill: 'black',
            radius: 2,
            opacity: 1,
        },
        fit: {
            line: {
                visible: true,
                dash: [5, 5],
                stroke: common_1.ColorVariant.Series,
                opacity: 1,
            },
        },
    },
    bubbleSeriesStyle: {
        point: {
            visible: true,
            strokeWidth: 1,
            fill: 'black',
            radius: 2,
            opacity: 1,
        },
    },
    areaSeriesStyle: {
        area: {
            visible: true,
            opacity: 0.3,
        },
        line: {
            visible: true,
            strokeWidth: 1,
            opacity: 1,
        },
        point: {
            visible: false,
            fill: 'black',
            strokeWidth: 0.5,
            radius: 1,
            opacity: 1,
        },
        fit: {
            line: {
                visible: true,
                dash: [5, 5],
                stroke: common_1.ColorVariant.Series,
                opacity: 1,
            },
            area: {
                visible: true,
                opacity: 0.15,
                fill: common_1.ColorVariant.Series,
            },
        },
    },
    barSeriesStyle: {
        rect: {
            opacity: 1,
        },
        rectBorder: {
            visible: false,
            strokeWidth: 1,
        },
        displayValue: {
            fontSize: 8,
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            padding: 0,
            fill: '#999',
            offsetX: 0,
            offsetY: 0,
        },
    },
    arcSeriesStyle: {
        arc: {
            visible: true,
            stroke: 'white',
            strokeWidth: 1,
            opacity: 1,
        },
    },
    sharedStyle: theme_common_1.DEFAULT_GEOMETRY_STYLES,
    scales: {
        barsPadding: 0.25,
        histogramPadding: 0.05,
    },
    axes: {
        axisTitle: {
            fontSize: 12,
            fontFamily: 'sans-serif',
            padding: {
                inner: 8,
                outer: 0,
            },
            fill: '#D4D4D4',
            visible: true,
        },
        axisPanelTitle: {
            fontSize: 10,
            fontFamily: 'sans-serif',
            padding: {
                inner: 8,
                outer: 0,
            },
            fill: '#D4D4D4',
            visible: true,
        },
        axisLine: {
            visible: true,
            stroke: '#444',
            strokeWidth: 1,
        },
        tickLabel: {
            visible: true,
            fontSize: 10,
            fontFamily: 'sans-serif',
            fontStyle: 'normal',
            fill: '#999',
            padding: 0,
            rotation: 0,
            offset: {
                x: 0,
                y: 0,
                reference: 'local',
            },
            alignment: {
                vertical: 'near',
                horizontal: 'near',
            },
        },
        tickLine: {
            visible: true,
            stroke: '#444',
            strokeWidth: 1,
            size: 10,
            padding: 10,
        },
        gridLine: {
            horizontal: {
                visible: false,
                stroke: '#D3DAE6',
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
            vertical: {
                visible: false,
                stroke: '#D3DAE6',
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
            lumaSteps: [63, 103, 159, 191, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255],
        },
    },
    colors: {
        vizColors: colors_1.palettes.echPaletteColorBlind.colors,
        defaultVizColor: theme_common_1.DEFAULT_MISSING_COLOR,
    },
    legend: {
        verticalWidth: 200,
        horizontalHeight: 64,
        spacingBuffer: 10,
        margin: 0,
        labelOptions: {
            maxLines: 1,
        },
    },
    crosshair: {
        band: {
            fill: '#2A2A2A',
            visible: true,
        },
        line: {
            stroke: '#999',
            strokeWidth: 1,
            visible: true,
        },
        crossLine: {
            stroke: '#999',
            strokeWidth: 1,
            dash: [5, 5],
            visible: true,
        },
    },
    background: {
        color: 'transparent',
    },
    goal: {
        minFontSize: 8,
        maxFontSize: 64,
        tickLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: 'white',
        },
        majorLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: 'white',
        },
        minorLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: 'white',
        },
        majorCenterLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: 'white',
        },
        minorCenterLabel: {
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            fill: 'white',
        },
        targetLine: {
            stroke: 'white',
        },
        tickLine: {
            stroke: 'snow',
        },
        progressLine: {
            stroke: 'white',
        },
    },
};
//# sourceMappingURL=dark_theme.js.map