function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import PropTypes from "prop-types";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { memo, forwardRef, useEffect, useMemo, useState } from 'react';
import classNames from 'classnames';
import { highlight, listLanguages } from 'refractor';
import { FixedSizeList } from 'react-window';
import AutoSizer from 'react-virtualized-auto-sizer';
import { keys, useCombinedRefs } from '../../services';
import { EuiButtonIcon } from '../button';
import { keysOf } from '../common';
import { EuiCopy } from '../copy';
import { EuiFocusTrap } from '../focus_trap';
import { EuiI18n } from '../i18n';
import { useInnerText } from '../inner_text';
import { useMutationObserver } from '../observer/mutation_observer';
import { useResizeObserver } from '../observer/resize_observer';
import { EuiOverlayMask } from '../overlay_mask';
import { highlightByLine, nodeToHtml } from './utils'; // eslint-disable-next-line local/forward-ref

var virtualizedOuterElement = function virtualizedOuterElement(_ref) {
  var className = _ref.className;
  return /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (props, ref) {
    return /*#__PURE__*/React.createElement("pre", _extends({}, props, {
      ref: ref,
      className: className,
      tabIndex: 0
    }));
  }));
}; // eslint-disable-next-line local/forward-ref


var virtualizedInnerElement = function virtualizedInnerElement(_ref2) {
  var className = _ref2.className,
      onKeyDown = _ref2.onKeyDown;
  return /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (props, ref) {
    return /*#__PURE__*/React.createElement("code", _extends({}, props, {
      ref: ref,
      className: className,
      onKeyDown: onKeyDown
    }));
  }));
};

var ListRow = function ListRow(_ref3) {
  var data = _ref3.data,
      index = _ref3.index,
      style = _ref3.style;
  var row = data[index];
  row.properties.style = style;
  return nodeToHtml(row, index, data, 0);
};

var SUPPORTED_LANGUAGES = listLanguages();
var DEFAULT_LANGUAGE = 'text'; // Based on observed line height for non-virtualized code blocks

var fontSizeToRowHeightMap = {
  s: 18,
  m: 21,
  l: 21
};
var fontSizeToClassNameMap = {
  s: 'euiCodeBlock--fontSmall',
  m: 'euiCodeBlock--fontMedium',
  l: 'euiCodeBlock--fontLarge'
};
export var FONT_SIZES = keysOf(fontSizeToClassNameMap);
var paddingSizeToClassNameMap = {
  none: '',
  s: 'euiCodeBlock--paddingSmall',
  m: 'euiCodeBlock--paddingMedium',
  l: 'euiCodeBlock--paddingLarge'
};
export var PADDING_SIZES = keysOf(paddingSizeToClassNameMap); // overflowHeight is required when using virtualization

/**
 * This is the base component extended by EuiCode and EuiCodeBlock.
 * These components share the same propTypes definition with EuiCodeBlockImpl.
 */
export var EuiCodeBlockImpl = function EuiCodeBlockImpl(_ref4) {
  var _ref4$transparentBack = _ref4.transparentBackground,
      transparentBackground = _ref4$transparentBack === void 0 ? false : _ref4$transparentBack,
      _ref4$paddingSize = _ref4.paddingSize,
      paddingSize = _ref4$paddingSize === void 0 ? 'l' : _ref4$paddingSize,
      _ref4$fontSize = _ref4.fontSize,
      fontSize = _ref4$fontSize === void 0 ? 's' : _ref4$fontSize,
      _ref4$isCopyable = _ref4.isCopyable,
      isCopyable = _ref4$isCopyable === void 0 ? false : _ref4$isCopyable,
      _ref4$whiteSpace = _ref4.whiteSpace,
      whiteSpace = _ref4$whiteSpace === void 0 ? 'pre-wrap' : _ref4$whiteSpace,
      _ref4$language = _ref4.language,
      _language = _ref4$language === void 0 ? DEFAULT_LANGUAGE : _ref4$language,
      inline = _ref4.inline,
      children = _ref4.children,
      className = _ref4.className,
      overflowHeight = _ref4.overflowHeight,
      _isVirtualized = _ref4.isVirtualized,
      _ref4$lineNumbers = _ref4.lineNumbers,
      lineNumbers = _ref4$lineNumbers === void 0 ? false : _ref4$lineNumbers,
      rest = _objectWithoutProperties(_ref4, ["transparentBackground", "paddingSize", "fontSize", "isCopyable", "whiteSpace", "language", "inline", "children", "className", "overflowHeight", "isVirtualized", "lineNumbers"]);

  var language = useMemo(function () {
    return SUPPORTED_LANGUAGES.includes(_language) ? _language : DEFAULT_LANGUAGE;
  }, [_language]);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isFullScreen = _useState2[0],
      setIsFullScreen = _useState2[1];

  var _useState3 = useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      wrapperRef = _useState4[0],
      setWrapperRef = _useState4[1];

  var _useInnerText = useInnerText(''),
      _useInnerText2 = _slicedToArray(_useInnerText, 2),
      innerTextRef = _useInnerText2[0],
      _innerText = _useInnerText2[1];

  var innerText = useMemo(function () {
    return _innerText === null || _innerText === void 0 ? void 0 : _innerText.replace(/[\r\n?]{2}|\n\n/g, '\n');
  }, [_innerText]);

  var _useState5 = useState(-1),
      _useState6 = _slicedToArray(_useState5, 2),
      tabIndex = _useState6[0],
      setTabIndex = _useState6[1];

  var combinedRef = useCombinedRefs([innerTextRef, setWrapperRef]);

  var _useResizeObserver = useResizeObserver(wrapperRef),
      width = _useResizeObserver.width,
      height = _useResizeObserver.height;

  var rowHeight = useMemo(function () {
    return fontSizeToRowHeightMap[fontSize];
  }, [fontSize]);
  var lineNumbersConfig = useMemo(function () {
    var config = _typeof(lineNumbers) === 'object' ? lineNumbers : {};
    return lineNumbers ? _objectSpread({
      start: 1,
      show: true
    }, config) : {
      start: 1,
      show: false
    };
  }, [lineNumbers]); // Used by `FixedSizeList` when `isVirtualized=true` or `children` is parsable (`isVirtualized=true`)

  var data = useMemo(function () {
    if (typeof children !== 'string') {
      return [];
    }

    return inline ? highlight(children, language) : highlightByLine(children, language, lineNumbersConfig);
  }, [children, language, inline, lineNumbersConfig]);
  var isVirtualized = useMemo(function () {
    return _isVirtualized && Array.isArray(data);
  }, [_isVirtualized, data]); // Used by `pre` when `isVirtualized=false` or `children` is not parsable (`isVirtualized=false`)

  var content = useMemo(function () {
    if (!Array.isArray(data) || data.length < 1) {
      return children;
    }

    return data.map(nodeToHtml);
  }, [data, children]);

  var doesOverflow = function doesOverflow() {
    if (!wrapperRef) return;
    var clientWidth = wrapperRef.clientWidth,
        clientHeight = wrapperRef.clientHeight,
        scrollWidth = wrapperRef.scrollWidth,
        scrollHeight = wrapperRef.scrollHeight;
    var doesOverflow = scrollHeight > clientHeight || scrollWidth > clientWidth;
    setTabIndex(doesOverflow ? 0 : -1);
  };

  useMutationObserver(wrapperRef, doesOverflow, {
    subtree: true,
    childList: true
  });
  useEffect(doesOverflow, [width, height, wrapperRef]);

  var onKeyDown = function onKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      closeFullScreen();
    }
  };

  var toggleFullScreen = function toggleFullScreen() {
    setIsFullScreen(!isFullScreen);
  };

  var closeFullScreen = function closeFullScreen() {
    setIsFullScreen(false);
  };

  var classes = classNames('euiCodeBlock', fontSizeToClassNameMap[fontSize], paddingSizeToClassNameMap[paddingSize], {
    'euiCodeBlock--transparentBackground': transparentBackground,
    'euiCodeBlock--inline': inline,
    'euiCodeBlock--hasControl': isCopyable || overflowHeight,
    'euiCodeBlock--hasBothControls': isCopyable && overflowHeight,
    'euiCodeBlock--hasLineNumbers': lineNumbersConfig.show
  }, _defineProperty({
    prismjs: !(className === null || className === void 0 ? void 0 : className.includes('prismjs'))
  }, "language-".concat(language || 'none'), !(className === null || className === void 0 ? void 0 : className.includes('language'))), className);
  var codeClasses = classNames('euiCodeBlock__code', language);
  var preClasses = classNames('euiCodeBlock__pre', {
    'euiCodeBlock__pre--whiteSpacePre': whiteSpace === 'pre',
    'euiCodeBlock__pre--whiteSpacePreWrap': whiteSpace === 'pre-wrap',
    'euiCodeBlock__pre--isVirtualized': isVirtualized
  });
  var optionalStyles = {};

  if (overflowHeight) {
    var property = typeof overflowHeight === 'string' ? 'height' : 'maxHeight';
    optionalStyles[property] = overflowHeight;
  }

  var codeSnippet = /*#__PURE__*/React.createElement("code", _extends({
    className: codeClasses
  }, rest), content);
  var wrapperProps = {
    className: classes,
    style: optionalStyles
  };

  if (inline) {
    return /*#__PURE__*/React.createElement("span", wrapperProps, codeSnippet);
  }

  var getCopyButton = function getCopyButton(_textToCopy) {
    var copyButton; // Fallback to `children` in the case of virtualized blocks.

    var textToCopy = _textToCopy || "".concat(children);

    if (isCopyable && textToCopy) {
      copyButton = /*#__PURE__*/React.createElement("div", {
        className: "euiCodeBlock__copyButton"
      }, /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiCodeBlock.copyButton",
        default: "Copy"
      }, function (copyButton) {
        return /*#__PURE__*/React.createElement(EuiCopy, {
          textToCopy: textToCopy
        }, function (copy) {
          return /*#__PURE__*/React.createElement(EuiButtonIcon, {
            onClick: copy,
            iconType: "copyClipboard",
            color: "text",
            "aria-label": copyButton
          });
        });
      }));
    }

    return copyButton;
  };

  var fullScreenButton;

  if (!inline && overflowHeight) {
    fullScreenButton = /*#__PURE__*/React.createElement(EuiI18n, {
      tokens: ['euiCodeBlock.fullscreenCollapse', 'euiCodeBlock.fullscreenExpand'],
      defaults: ['Collapse', 'Expand']
    }, function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 2),
          fullscreenCollapse = _ref6[0],
          fullscreenExpand = _ref6[1];

      return /*#__PURE__*/React.createElement(EuiButtonIcon, {
        className: "euiCodeBlock__fullScreenButton",
        onClick: toggleFullScreen,
        iconType: isFullScreen ? 'cross' : 'fullScreen',
        color: "text",
        "aria-label": isFullScreen ? fullscreenCollapse : fullscreenExpand
      });
    });
  }

  var getCodeBlockControls = function getCodeBlockControls(textToCopy) {
    var codeBlockControls;
    var copyButton = getCopyButton(textToCopy);

    if (copyButton || fullScreenButton) {
      codeBlockControls = /*#__PURE__*/React.createElement("div", {
        className: "euiCodeBlock__controls"
      }, fullScreenButton, copyButton);
    }

    return codeBlockControls;
  };

  var getFullScreenDisplay = function getFullScreenDisplay(codeBlockControls) {
    var fullScreenDisplay;

    if (isFullScreen) {
      // Force fullscreen to use large font and padding.
      var fullScreenClasses = classNames('euiCodeBlock', fontSizeToClassNameMap[fontSize], 'euiCodeBlock-paddingLarge', 'euiCodeBlock-isFullScreen', className);
      fullScreenDisplay = /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(EuiFocusTrap, {
        clickOutsideDisables: true
      }, /*#__PURE__*/React.createElement("div", {
        className: fullScreenClasses
      }, isVirtualized ? /*#__PURE__*/React.createElement(AutoSizer, null, function (_ref7) {
        var height = _ref7.height,
            width = _ref7.width;
        return /*#__PURE__*/React.createElement(FixedSizeList, {
          height: height,
          width: width,
          itemData: data,
          itemSize: rowHeight,
          itemCount: data.length,
          outerElementType: virtualizedOuterElement({
            className: preClasses
          }),
          innerElementType: virtualizedInnerElement({
            className: codeClasses,
            onKeyDown: onKeyDown
          })
        }, ListRow);
      }) : /*#__PURE__*/React.createElement("pre", {
        className: preClasses,
        tabIndex: 0
      }, /*#__PURE__*/React.createElement("code", {
        className: codeClasses,
        onKeyDown: onKeyDown
      }, content)), codeBlockControls)));
    }

    return fullScreenDisplay;
  };

  var codeBlockControls = getCodeBlockControls(innerText);
  return /*#__PURE__*/React.createElement("div", wrapperProps, isVirtualized ? /*#__PURE__*/React.createElement(AutoSizer, {
    disableHeight: typeof overflowHeight === 'number'
  }, function (_ref8) {
    var height = _ref8.height,
        width = _ref8.width;
    return /*#__PURE__*/React.createElement(FixedSizeList, {
      height: height !== null && height !== void 0 ? height : overflowHeight,
      width: width,
      itemData: data,
      itemSize: rowHeight,
      itemCount: data.length,
      outerElementType: virtualizedOuterElement({
        className: preClasses
      }),
      innerElementType: virtualizedInnerElement({
        className: codeClasses,
        onKeyDown: onKeyDown
      })
    }, ListRow);
  }) : /*#__PURE__*/React.createElement("pre", {
    ref: combinedRef,
    style: optionalStyles,
    className: preClasses,
    tabIndex: tabIndex
  }, codeSnippet), codeBlockControls, getFullScreenDisplay(codeBlockControls));
};
EuiCodeBlockImpl.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  fontSize: PropTypes.oneOf(["s", "m", "l"]),

  /**
     * Displays the passed code in an inline format. Also removes any margins set.
     */
  inline: PropTypes.bool,

  /**
     * Displays an icon button to copy the code snippet to the clipboard.
     */
  isCopyable: PropTypes.bool,

  /**
     * Sets the syntax highlighting for a specific language
     * @see https://prismjs.com/#supported-languages
     * for options
     */
  language: PropTypes.string,
  paddingSize: PropTypes.oneOf(["none", "s", "m", "l"]),
  transparentBackground: PropTypes.bool,

  /**
     * Specify how `white-space` inside the element is handled.
     * `pre` respects line breaks/white space but doesn't force them to wrap the line
     * `pre-wrap` respects line breaks/white space but does force them to wrap the line when necessary.
     */
  whiteSpace: PropTypes.oneOf(["pre", "pre-wrap"]),

  /**
     * Displays line numbers.
     * Optionally accepts a configuration object for setting the starting number and visual highlighting ranges:
     * `{ start: 100, highlight: '1, 5-10, 20-30, 40' }`
     */
  lineNumbers: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    start: PropTypes.number,
    highlight: PropTypes.string
  }).isRequired]),

  /**
       * Renders code block lines virtually.
       * Useful for improving load times of large code blocks.
       * `overflowHeight` is required when using this configuration.
       */
  isVirtualized: PropTypes.oneOfType([PropTypes.oneOf([true]).isRequired, PropTypes.bool]),

  /**
       * Sets the maximum container height.
       * Accepts a pixel value (`300`) or a percentage (`'100%'`)
       * Ensure the container has calcuable height when using a percentage
       */
  overflowHeight: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.string.isRequired]).isRequired, PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.string.isRequired])])
};