"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiKeyPadMenu = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _form_label = require("../form/form_label/form_label");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiKeyPadMenu = function EuiKeyPadMenu(_ref) {
  var children = _ref.children,
      className = _ref.className,
      checkable = _ref.checkable,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "checkable"]);
  var classes = (0, _classnames.default)('euiKeyPadMenu', className);
  var legend = (0, _typeof2.default)(checkable) === 'object' && checkable.legend ? /*#__PURE__*/_react.default.createElement(_form_label.EuiFormLabel, (0, _extends2.default)({}, checkable.legendProps, {
    type: "legend"
  }), checkable.legend) : undefined;
  return checkable ? /*#__PURE__*/_react.default.createElement("fieldset", (0, _extends2.default)({
    className: classes,
    "aria-label": (0, _typeof2.default)(checkable) === 'object' ? checkable.ariaLegend : undefined
  }, rest), legend, children) : /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
    className: classes
  }, rest), _react.default.Children.map(children, function (child) {
    return /*#__PURE__*/_react.default.createElement("li", null, child);
  }));
};

exports.EuiKeyPadMenu = EuiKeyPadMenu;
EuiKeyPadMenu.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Renders the the group as a `fieldset`.
       * Set to `true` to customize the labelling, or pass an #EuiKeyPadMenuCheckableProps object to add a `legend` or `ariaLegend`
       */
  checkable: _propTypes.default.oneOfType([_propTypes.default.shape({
    /**
         * Rendered within a `legend` to label the `fieldset`.
         * To create a visually hidden legend, use `ariaLegend`
         */
    legend: _propTypes.default.node,

    /**
         * Pass through props to a `EuiFormLabel` component, except for `type`
         */
    legendProps: _propTypes.default.any,

    /**
         * Custom aria-attribute for creating a *visually hidden* legend.
         * To create a visible legend, use `legend`
         */
    ariaLegend: _propTypes.default.string
  }).isRequired, _propTypes.default.oneOf([true])])
};