"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanAnimate = exports.useScreenReaderOnly = exports.useXScrollWithShadows = exports.useYScrollWithShadows = exports.useXScroll = exports.useYScroll = exports.useScrollBar = exports.useInnerBorder = void 0;

var _chromaJs = _interopRequireDefault(require("chroma-js"));

var _hooks = require("../../services/theme/hooks");

var _color = require("../../services/color");

var _shadow = require("./_shadow");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * NOTE: These were quick conversions of their Sass counterparts.
 *       They have yet to be used/tested.
 */
// Useful border shade when dealing with images of unknown color.
var useInnerBorder = function useInnerBorder(_ref) {
  var _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'dark' : _ref$type,
      _ref$borderRadius = _ref.borderRadius,
      borderRadius = _ref$borderRadius === void 0 ? 0 : _ref$borderRadius,
      _ref$alpha = _ref.alpha,
      alpha = _ref$alpha === void 0 ? 0.1 : _ref$alpha;

  var _useEuiTheme = (0, _hooks.useEuiTheme)(),
      colors = _useEuiTheme.euiTheme.colors;

  var color = (0, _chromaJs.default)(type === 'dark' ? colors.darkestShade : colors.emptyShade).alpha(alpha).css();
  return "\n    position: relative;\n\n    &:after {\n      position: absolute;\n      top: 0;\n      left: 0;\n      right: 0;\n      bottom: 0;\n      border-radius: ".concat(borderRadius, ";\n      content: '';\n      pointer-events: none;\n      border: 1px solid ").concat(color, ";\n    }\n  ");
}; // Set scroll bar appearance on Chrome (and firefox).


exports.useInnerBorder = useInnerBorder;

var useScrollBar = function useScrollBar() {
  var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _thumbColor = _ref2.thumbColor,
      _trackBackgroundColor = _ref2.trackBackgroundColor;

  var _useEuiTheme2 = (0, _hooks.useEuiTheme)(),
      _useEuiTheme2$euiThem = _useEuiTheme2.euiTheme,
      colors = _useEuiTheme2$euiThem.colors,
      size = _useEuiTheme2$euiThem.size;

  var thumbColor = _thumbColor || colors.darkShade;
  var trackBackgroundColor = _trackBackgroundColor || 'transparent'; // Firefox's scrollbar coloring cascades, but the sizing does not,
  // so it's being added to this mixin for allowing support wherever custom scrollbars are

  return "\n    scrollbar-width: thin;\n    &::-webkit-scrollbar {\n      width: ".concat(size.base, ";\n      height: ").concat(size.base, ";\n    }\n    &::-webkit-scrollbar-thumb {\n      background-color: ").concat((0, _color.transparentize)(thumbColor, 0.5), ";\n      border: calc(").concat(size.base, " * 0.75) solid ").concat(trackBackgroundColor, ";\n      background-clip: content-box;\n    }\n    &::-webkit-scrollbar-corner,\n    &::-webkit-scrollbar-track {\n      background-color: ").concat(trackBackgroundColor, ";\n    }\n  ");
};
/**
 * 1. Focus rings shouldn't be visible on scrollable regions, but a11y requires them to be focusable.
 *    Browser's supporting `:focus-visible` will still show outline on keyboard focus only.
 *    Others like Safari, won't show anything at all.
 */
// Just overflow and scrollbars


exports.useScrollBar = useScrollBar;

var useYScroll = function useYScroll() {
  return "\n  ".concat(useScrollBar(), "\n  height: 100%;\n  overflow-y: auto;\n  overflow-x: hidden;\n  &:focus {\n    outline: none; /* 1 */\n  }\n");
};

exports.useYScroll = useYScroll;

var useXScroll = function useXScroll() {
  return "\n  ".concat(useScrollBar(), "\n  overflow-x: auto;\n\n  &:focus {\n    outline: none; /* 1 */\n  }\n");
}; // // The full overflow with shadow


exports.useXScroll = useXScroll;

var useYScrollWithShadows = function useYScrollWithShadows() {
  return "\n  ".concat(useYScroll(), "\n  ").concat((0, _shadow.useOverflowShadow)({
    direction: 'y'
  }), "\n");
};

exports.useYScrollWithShadows = useYScrollWithShadows;

var useXScrollWithShadows = function useXScrollWithShadows() {
  return "\n  ".concat(useXScroll(), "\n  ").concat((0, _shadow.useOverflowShadow)({
    direction: 'x'
  }), "\n");
}; // Hiding elements offscreen to only be read by screen reader


exports.useXScrollWithShadows = useXScrollWithShadows;

var useScreenReaderOnly = function useScreenReaderOnly() {
  return "\n  position: absolute;\n  left: -10000px;\n  top: auto;\n  width: 1px;\n  height: 1px;\n  overflow: hidden;\n";
}; // Doesn't have reduced motion turned on


exports.useScreenReaderOnly = useScreenReaderOnly;

var useCanAnimate = function useCanAnimate(content) {
  return "\n  @media screen and (prefers-reduced-motion: no-preference) {\n    ".concat(content, "\n  }\n");
};

exports.useCanAnimate = useCanAnimate;