"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyConfigOverrides = void 0;
var _saferLodashSet = require("@elastic/safer-lodash-set");
var _read_argv = require("./read_argv");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Manually applies the specific configuration overrides we need to load the APM config.
 * Currently, only these are needed:
 *   - server.uuid
 *   - path.data
 */
const applyConfigOverrides = (config, argv) => {
  const serverUuid = (0, _read_argv.getArgValue)(argv, '--server.uuid');
  if (serverUuid) {
    (0, _saferLodashSet.set)(config, 'server.uuid', serverUuid);
  }
  const dataPath = (0, _read_argv.getArgValue)(argv, '--path.data');
  if (dataPath) {
    (0, _saferLodashSet.set)(config, 'path.data', dataPath);
  }
};
exports.applyConfigOverrides = applyConfigOverrides;