"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasConfigPathIntersection = hasConfigPathIntersection;
exports.isConfigPath = isConfigPath;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @public */

/**
 * Checks whether specified value can be considered as config path.
 * @param value Value to check.
 * @public
 */
function isConfigPath(value) {
  if (!value) {
    return false;
  }
  if (typeof value === 'string') {
    return true;
  }
  return Array.isArray(value) && value.every(segment => typeof segment === 'string');
}

/**
 * Represents config store.
 * @internal
 */

const pathDelimiter = '.';
function hasConfigPathIntersection(leafPath, rootPath) {
  if (!leafPath) {
    throw new Error('leafPath cannot be empty');
  }
  if (!rootPath) {
    throw new Error('rootPath cannot be empty');
  }
  const leafSegments = leafPath.split(pathDelimiter);
  const rootSegments = rootPath.split(pathDelimiter);
  return rootSegments.every((rootSegment, index) => leafSegments[index] === rootSegment);
}