import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as ast from '../ast';
export function buildNodeParams(child) {
  return {
    arguments: [child]
  };
}
export function toElasticsearchQuery(node, indexPattern) {
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var context = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var _node$arguments = _slicedToArray(node.arguments, 1),
    argument = _node$arguments[0];
  return {
    bool: {
      must_not: ast.toElasticsearchQuery(argument, indexPattern, config, context)
    }
  };
}