"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeRt = mergeRt;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _Either = require("fp-ts/lib/Either");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// this is similar to t.intersection, but does a deep merge
// instead of a shallow merge

function mergeRt(...types) {
  const mergeType = new t.Type('merge', u => {
    return types.every(type => type.is(u));
  }, (input, context) => {
    const errors = [];
    const successes = [];
    const results = types.map((type, index) => type.validate(input, context.concat({
      key: String(index),
      type,
      actual: input
    })));
    results.forEach(result => {
      if ((0, _Either.isLeft)(result)) {
        errors.push(...result.left);
      } else {
        successes.push(result.right);
      }
    });
    const mergedValues = (0, _lodash.merge)({}, ...successes);
    return errors.length > 0 ? t.failures(errors) : t.success(mergedValues);
  }, a => types.reduce((val, type) => type.encode(val), a));
  return {
    ...mergeType,
    _tag: 'MergeType',
    types
  };
}