"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnLoggerStringFormat = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _chalk = _interopRequireDefault(require("chalk"));
var _log_format = require("./log_format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const statuses = ['err', 'info', 'error', 'warning', 'fatal', 'status', 'debug'];
const typeColors = {
  log: 'white',
  req: 'green',
  res: 'green',
  ops: 'cyan',
  config: 'cyan',
  err: 'red',
  info: 'green',
  error: 'red',
  warning: 'red',
  fatal: 'magentaBright',
  status: 'yellowBright',
  debug: 'gray',
  server: 'gray',
  optmzr: 'white',
  manager: 'green',
  optimize: 'magentaBright',
  listening: 'magentaBright',
  scss: 'magentaBright'
};
const color = _lodash.default.memoize(name => {
  // @ts-expect-error couldn't even get rid of the error with an any cast
  return _chalk.default[typeColors[name]] || _lodash.default.identity;
});
const type = _lodash.default.memoize(t => {
  return color(t)(_lodash.default.pad(t, 7).slice(0, 7));
});
const prefix = process.env.isDevCliChild ? `${type('server')} ` : '';
class KbnLoggerStringFormat extends _log_format.BaseLogFormat {
  format(data) {
    const time = color('time')(this.extractAndFormatTimestamp(data, 'HH:mm:ss.SSS'));
    const msg = data.error ? color('error')(data.error.stack) : color('message')(data.message);
    const tags = (0, _lodash.default)(data.tags).sortBy(function (tag) {
      if (color(tag) === _lodash.default.identity) return `2${tag}`;
      if (_lodash.default.includes(statuses, tag)) return `0${tag}`;
      return `1${tag}`;
    }).reduce(function (s, t) {
      return s + `[${color(t)(t)}]`;
    }, '');
    return `${prefix}${type(data.type)} [${time}] ${tags} ${msg}`;
  }
}
exports.KbnLoggerStringFormat = KbnLoggerStringFormat;