/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable @typescript-eslint/naming-convention */

import * as t from 'io-ts';
import { NonEmptyArray, NonEmptyString, PositiveIntegerGreaterThanZero } from '@kbn/securitysolution-io-ts-types';
import { language } from '../language';
export var threat_query = t.string;
export var threatQueryOrUndefined = t.union([threat_query, t.undefined]);
export var threat_indicator_path = t.string;
export var threatIndicatorPathOrUndefined = t.union([threat_indicator_path, t.undefined]);
export var threat_filters = t.array(t.unknown); // Filters are not easily type-able yet

export var threatFiltersOrUndefined = t.union([threat_filters, t.undefined]);
export var threatMapEntry = t.exact(t.type({
  field: NonEmptyString,
  type: t.keyof({
    mapping: null
  }),
  value: NonEmptyString
}));
export var threatMappingEntries = t.array(threatMapEntry);
export var threatMap = t.exact(t.type({
  entries: threatMappingEntries
}));
export var threat_mapping = NonEmptyArray(threatMap, 'NonEmptyArray<ThreatMap>');
export var threatMappingOrUndefined = t.union([threat_mapping, t.undefined]);
export var threat_index = t.array(t.string);
export var threatIndexOrUndefined = t.union([threat_index, t.undefined]);
export var threat_language = t.union([language, t.undefined]);
export var threatLanguageOrUndefined = t.union([threat_language, t.undefined]);
export var concurrent_searches = PositiveIntegerGreaterThanZero;
export var concurrentSearchesOrUndefined = t.union([concurrent_searches, t.undefined]);
export var items_per_search = PositiveIntegerGreaterThanZero;
export var itemsPerSearchOrUndefined = t.union([items_per_search, t.undefined]);