/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { namespaceType } from '../default_namespace';
export var namespaceTypeArray = t.array(namespaceType);
/**
 * Types the DefaultNamespaceArray as:
 *   - If null or undefined, then a default string array of "single" will be used.
 *   - If it contains a string, then it is split along the commas and puts them into an array and validates it
 */
export var DefaultNamespaceArray = new t.Type('DefaultNamespaceArray', namespaceTypeArray.is, function (input, context) {
  if (input == null) {
    return t.success(['single']);
  } else if (typeof input === 'string') {
    var commaSeparatedValues = input.trim().split(',').map(function (value) {
      return value.trim();
    });
    return namespaceTypeArray.validate(commaSeparatedValues, context);
  }
  return t.failure(input, context);
}, String);