/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { get } from 'lodash/fp';
export var getGeneralFilters = function getGeneralFilters(filters, namespaceTypes) {
  return Object.keys(filters).map(function (filterKey) {
    var value = get(filterKey, filters);
    if (value != null && value.trim() !== '') {
      var filtersByNamespace = namespaceTypes.map(function (namespace) {
        var fieldToSearch = filterKey === 'name' ? 'name.text' : filterKey;
        return "".concat(namespace, ".attributes.").concat(fieldToSearch, ":").concat(value);
      }).join(' OR ');
      return "(".concat(filtersByNamespace, ")");
    } else return null;
  }).filter(function (item) {
    return item != null;
  }).join(' AND ');
};